package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PortBuilder extends me.snowdrop.istio.api.networking.v1beta1.PortFluentImpl<me.snowdrop.istio.api.networking.v1beta1.PortBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.Port,me.snowdrop.istio.api.networking.v1beta1.PortBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.PortFluent<?> fluent;
    Boolean validationEnabled;

    public PortBuilder(){
            this(true);
    }
    public PortBuilder(Boolean validationEnabled){
            this(new Port(), validationEnabled);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.PortFluent<?> fluent){
            this(fluent, true);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.PortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Port(), validationEnabled);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.PortFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.Port instance){
            this(fluent, instance, true);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.PortFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.Port instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withNumber(instance.getNumber()); 
            fluent.withProtocol(instance.getProtocol()); 
            fluent.withTargetPort(instance.getTargetPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.Port instance){
            this(instance,true);
    }
    public PortBuilder(me.snowdrop.istio.api.networking.v1beta1.Port instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withNumber(instance.getNumber()); 
            this.withProtocol(instance.getProtocol()); 
            this.withTargetPort(instance.getTargetPort()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.Port build(){
            Port buildable = new Port(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PortBuilder that = (PortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
