package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;

public class PortTrafficPolicyFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyFluent<A>{

    private me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder connectionPool;
    private me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder loadBalancer;
    private me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder outlierDetection;
    private me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder port;
    private me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder tls;

    public PortTrafficPolicyFluentImpl(){
    }
    public PortTrafficPolicyFluentImpl(me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy instance){
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectionPool instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings getConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings buildConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public A withConnectionPool(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings connectionPool){
            _visitables.get("connectionPool").remove(this.connectionPool);
            if (connectionPool!=null){ this.connectionPool= new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} return (A) this;
    }

    public Boolean hasConnectionPool(){
            return this.connectionPool != null;
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool(){
            return new ConnectionPoolNestedImpl();
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
            return new ConnectionPoolNestedImpl(item);
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool());
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings buildLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings loadBalancer){
            _visitables.get("loadBalancer").remove(this.loadBalancer);
            if (loadBalancer!=null){ this.loadBalancer= new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer(){
            return this.loadBalancer != null;
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
            return new LoadBalancerNestedImpl(item);
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOutlierDetection instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.OutlierDetection getOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.OutlierDetection buildOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public A withOutlierDetection(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection outlierDetection){
            _visitables.get("outlierDetection").remove(this.outlierDetection);
            if (outlierDetection!=null){ this.outlierDetection= new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} return (A) this;
    }

    public Boolean hasOutlierDetection(){
            return this.outlierDetection != null;
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection(){
            return new OutlierDetectionNestedImpl();
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
            return new OutlierDetectionNestedImpl(item);
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection());
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder().build());
    }

    public PortTrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.PortSelector getPort(){
            return this.port!=null?this.port.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortSelector buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(me.snowdrop.istio.api.networking.v1beta1.PortSelector port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(Integer number){
            return (A)withPort(new PortSelector(number));
    }

    public PortTrafficPolicyFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public PortTrafficPolicyFluent.PortNested<A> withNewPortLike(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
            return new PortNestedImpl(item);
    }

    public PortTrafficPolicyFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public PortTrafficPolicyFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder().build());
    }

    public PortTrafficPolicyFluent.PortNested<A> editOrNewPortLike(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public PortTrafficPolicyFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public PortTrafficPolicyFluent.TlsNested<A> withNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
            return new TlsNestedImpl(item);
    }

    public PortTrafficPolicyFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public PortTrafficPolicyFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder().build());
    }

    public PortTrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PortTrafficPolicyFluentImpl that = (PortTrafficPolicyFluentImpl) o;
            if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class ConnectionPoolNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsFluentImpl<PortTrafficPolicyFluent.ConnectionPoolNested<N>> implements PortTrafficPolicyFluent.ConnectionPoolNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder builder;
    
            ConnectionPoolNestedImpl(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(this, item);
            }
            ConnectionPoolNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool(){
            return and();
    }

}
    public class LoadBalancerNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluentImpl<PortTrafficPolicyFluent.LoadBalancerNested<N>> implements PortTrafficPolicyFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder builder;
    
            LoadBalancerNestedImpl(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(this, item);
            }
            LoadBalancerNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}
    public class OutlierDetectionNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionFluentImpl<PortTrafficPolicyFluent.OutlierDetectionNested<N>> implements PortTrafficPolicyFluent.OutlierDetectionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder builder;
    
            OutlierDetectionNestedImpl(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(this, item);
            }
            OutlierDetectionNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection(){
            return and();
    }

}
    public class PortNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PortSelectorFluentImpl<PortTrafficPolicyFluent.PortNested<N>> implements PortTrafficPolicyFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder builder;
    
            PortNestedImpl(me.snowdrop.istio.api.networking.v1beta1.PortSelector item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortSelectorBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluentImpl<PortTrafficPolicyFluent.TlsNested<N>> implements PortTrafficPolicyFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder builder;
    
            TlsNestedImpl(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) PortTrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}


}
