
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destination",
    "weight"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class RouteDestination implements Serializable
{

    /**
     * 
     */
    @JsonProperty("destination")
    @JsonPropertyDescription("")
    private Destination destination;
    /**
     * 
     */
    @JsonProperty("weight")
    @JsonPropertyDescription("")
    private Integer weight;
    private final static long serialVersionUID = -3063549540673583541L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RouteDestination() {
    }

    /**
     * 
     * @param destination
     * @param weight
     */
    public RouteDestination(Destination destination, Integer weight) {
        super();
        this.destination = destination;
        this.weight = weight;
    }

    /**
     * 
     */
    public Destination getDestination() {
        return destination;
    }

    /**
     * 
     */
    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    /**
     * 
     */
    public Integer getWeight() {
        return weight;
    }

    /**
     * 
     */
    public void setWeight(Integer weight) {
        this.weight = weight;
    }

}
