
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "bind",
    "defaultEndpoint",
    "hosts",
    "name",
    "port",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Server implements Serializable
{

    /**
     * 
     */
    @JsonProperty("bind")
    @JsonPropertyDescription("")
    private String bind;
    /**
     * 
     */
    @JsonProperty("defaultEndpoint")
    @JsonPropertyDescription("")
    private String defaultEndpoint;
    /**
     * 
     */
    @JsonProperty("hosts")
    @JsonPropertyDescription("")
    private List<String> hosts = new ArrayList<String>();
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Port port;
    /**
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    private ServerTLSSettings tls;
    private final static long serialVersionUID = -8007415060699384807L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Server() {
    }

    /**
     * 
     * @param bind
     * @param port
     * @param hosts
     * @param name
     * @param defaultEndpoint
     * @param tls
     */
    public Server(String bind, String defaultEndpoint, List<String> hosts, String name, Port port, ServerTLSSettings tls) {
        super();
        this.bind = bind;
        this.defaultEndpoint = defaultEndpoint;
        this.hosts = hosts;
        this.name = name;
        this.port = port;
        this.tls = tls;
    }

    /**
     * 
     */
    public String getBind() {
        return bind;
    }

    /**
     * 
     */
    public void setBind(String bind) {
        this.bind = bind;
    }

    /**
     * 
     */
    public String getDefaultEndpoint() {
        return defaultEndpoint;
    }

    /**
     * 
     */
    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    /**
     * 
     */
    public List<String> getHosts() {
        return hosts;
    }

    /**
     * 
     */
    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     */
    public Port getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Port port) {
        this.port = port;
    }

    /**
     * 
     */
    public ServerTLSSettings getTls() {
        return tls;
    }

    /**
     * 
     */
    public void setTls(ServerTLSSettings tls) {
        this.tls = tls;
    }

}
