package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ServerFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.ServerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.ServerFluent<A>{

    private String bind;
    private String defaultEndpoint;
    private List<String> hosts;
    private String name;
    private me.snowdrop.istio.api.networking.v1beta1.PortBuilder port;
    private me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder tls;

    public ServerFluentImpl(){
    }
    public ServerFluentImpl(me.snowdrop.istio.api.networking.v1beta1.Server instance){
            this.withBind(instance.getBind()); 
            this.withDefaultEndpoint(instance.getDefaultEndpoint()); 
            this.withHosts(instance.getHosts()); 
            this.withName(instance.getName()); 
            this.withPort(instance.getPort()); 
            this.withTls(instance.getTls()); 
    }

    public String getBind(){
            return this.bind;
    }

    public A withBind(String bind){
            this.bind=bind; return (A) this;
    }

    public Boolean hasBind(){
            return this.bind != null;
    }

    public A withNewBind(String arg1){
            return (A)withBind(new String(arg1));
    }

    public A withNewBind(StringBuilder arg1){
            return (A)withBind(new String(arg1));
    }

    public A withNewBind(StringBuffer arg1){
            return (A)withBind(new String(arg1));
    }

    public String getDefaultEndpoint(){
            return this.defaultEndpoint;
    }

    public A withDefaultEndpoint(String defaultEndpoint){
            this.defaultEndpoint=defaultEndpoint; return (A) this;
    }

    public Boolean hasDefaultEndpoint(){
            return this.defaultEndpoint != null;
    }

    public A withNewDefaultEndpoint(String arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    public A withNewDefaultEndpoint(StringBuilder arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    public A withNewDefaultEndpoint(StringBuffer arg1){
            return (A)withDefaultEndpoint(new String(arg1));
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public A addNewHost(String arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuilder arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuffer arg1){
            return (A)addToHosts(new String(arg1));
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPort instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.Port getPort(){
            return this.port!=null?this.port.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.Port buildPort(){
            return this.port!=null?this.port.build():null;
    }

    public A withPort(me.snowdrop.istio.api.networking.v1beta1.Port port){
            _visitables.get("port").remove(this.port);
            if (port!=null){ this.port= new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(port); _visitables.get("port").add(this.port);} return (A) this;
    }

    public Boolean hasPort(){
            return this.port != null;
    }

    public A withNewPort(String name,Integer number,String protocol,Integer targetPort){
            return (A)withPort(new Port(name, number, protocol, targetPort));
    }

    public ServerFluent.PortNested<A> withNewPort(){
            return new PortNestedImpl();
    }

    public ServerFluent.PortNested<A> withNewPortLike(me.snowdrop.istio.api.networking.v1beta1.Port item){
            return new PortNestedImpl(item);
    }

    public ServerFluent.PortNested<A> editPort(){
            return withNewPortLike(getPort());
    }

    public ServerFluent.PortNested<A> editOrNewPort(){
            return withNewPortLike(getPort() != null ? getPort(): new me.snowdrop.istio.api.networking.v1beta1.PortBuilder().build());
    }

    public ServerFluent.PortNested<A> editOrNewPortLike(me.snowdrop.istio.api.networking.v1beta1.Port item){
            return withNewPortLike(getPort() != null ? getPort(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public ServerFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public ServerFluent.TlsNested<A> withNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings item){
            return new TlsNestedImpl(item);
    }

    public ServerFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public ServerFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder().build());
    }

    public ServerFluent.TlsNested<A> editOrNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServerFluentImpl that = (ServerFluentImpl) o;
            if (bind != null ? !bind.equals(that.bind) :that.bind != null) return false;
            if (defaultEndpoint != null ? !defaultEndpoint.equals(that.defaultEndpoint) :that.defaultEndpoint != null) return false;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class PortNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PortFluentImpl<ServerFluent.PortNested<N>> implements ServerFluent.PortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PortBuilder builder;
    
            PortNestedImpl(me.snowdrop.istio.api.networking.v1beta1.Port item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(this, item);
            }
            PortNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortBuilder(this);
            }
    
    public N and(){
            return (N) ServerFluentImpl.this.withPort(builder.build());
    }
    public N endPort(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsFluentImpl<ServerFluent.TlsNested<N>> implements ServerFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder builder;
    
            TlsNestedImpl(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) ServerFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}


}
