package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ServerTLSSettingsFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsFluent<A>{

    private String caCertificates;
    private List<String> cipherSuites;
    private String credentialName;
    private Boolean httpsRedirect;
    private me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol maxProtocolVersion;
    private me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol minProtocolVersion;
    private me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsMode mode;
    private String privateKey;
    private String serverCertificate;
    private List<String> subjectAltNames;
    private List<String> verifyCertificateHash;
    private List<String> verifyCertificateSpki;

    public ServerTLSSettingsFluentImpl(){
    }
    public ServerTLSSettingsFluentImpl(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettings instance){
            this.withCaCertificates(instance.getCaCertificates()); 
            this.withCipherSuites(instance.getCipherSuites()); 
            this.withCredentialName(instance.getCredentialName()); 
            this.withHttpsRedirect(instance.getHttpsRedirect()); 
            this.withMaxProtocolVersion(instance.getMaxProtocolVersion()); 
            this.withMinProtocolVersion(instance.getMinProtocolVersion()); 
            this.withMode(instance.getMode()); 
            this.withPrivateKey(instance.getPrivateKey()); 
            this.withServerCertificate(instance.getServerCertificate()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.withVerifyCertificateHash(instance.getVerifyCertificateHash()); 
            this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki()); 
    }

    public String getCaCertificates(){
            return this.caCertificates;
    }

    public A withCaCertificates(String caCertificates){
            this.caCertificates=caCertificates; return (A) this;
    }

    public Boolean hasCaCertificates(){
            return this.caCertificates != null;
    }

    public A withNewCaCertificates(String arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public A withNewCaCertificates(StringBuilder arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public A withNewCaCertificates(StringBuffer arg1){
            return (A)withCaCertificates(new String(arg1));
    }

    public A addToCipherSuites(int index,String item){
            if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
            this.cipherSuites.add(index, item);
            return (A)this;
    }

    public A setToCipherSuites(int index,String item){
            if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
            this.cipherSuites.set(index, item); return (A)this;
    }

    public A addToCipherSuites(String... items){
            if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
            for (String item : items) {this.cipherSuites.add(item);} return (A)this;
    }

    public A addAllToCipherSuites(Collection<String> items){
            if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
            for (String item : items) {this.cipherSuites.add(item);} return (A)this;
    }

    public A removeFromCipherSuites(String... items){
            for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
    }

    public A removeAllFromCipherSuites(Collection<String> items){
            for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
    }

    public List<String> getCipherSuites(){
            return this.cipherSuites;
    }

    public String getCipherSuite(int index){
            return this.cipherSuites.get(index);
    }

    public String getFirstCipherSuite(){
            return this.cipherSuites.get(0);
    }

    public String getLastCipherSuite(){
            return this.cipherSuites.get(cipherSuites.size() - 1);
    }

    public String getMatchingCipherSuite(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: cipherSuites) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCipherSuite(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: cipherSuites) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withCipherSuites(List<String> cipherSuites){
            if (this.cipherSuites != null) { _visitables.get("cipherSuites").removeAll(this.cipherSuites);}
            if (cipherSuites != null) {this.cipherSuites = new ArrayList<String>(); for (String item : cipherSuites){this.addToCipherSuites(item);}} else { this.cipherSuites = null;} return (A) this;
    }

    public A withCipherSuites(String... cipherSuites){
            if (this.cipherSuites != null) {this.cipherSuites.clear();}
            if (cipherSuites != null) {for (String item :cipherSuites){ this.addToCipherSuites(item);}} return (A) this;
    }

    public Boolean hasCipherSuites(){
            return cipherSuites != null && !cipherSuites.isEmpty();
    }

    public A addNewCipherSuite(String arg1){
            return (A)addToCipherSuites(new String(arg1));
    }

    public A addNewCipherSuite(StringBuilder arg1){
            return (A)addToCipherSuites(new String(arg1));
    }

    public A addNewCipherSuite(StringBuffer arg1){
            return (A)addToCipherSuites(new String(arg1));
    }

    public String getCredentialName(){
            return this.credentialName;
    }

    public A withCredentialName(String credentialName){
            this.credentialName=credentialName; return (A) this;
    }

    public Boolean hasCredentialName(){
            return this.credentialName != null;
    }

    public A withNewCredentialName(String arg1){
            return (A)withCredentialName(new String(arg1));
    }

    public A withNewCredentialName(StringBuilder arg1){
            return (A)withCredentialName(new String(arg1));
    }

    public A withNewCredentialName(StringBuffer arg1){
            return (A)withCredentialName(new String(arg1));
    }

    public Boolean isHttpsRedirect(){
            return this.httpsRedirect;
    }

    public A withHttpsRedirect(Boolean httpsRedirect){
            this.httpsRedirect=httpsRedirect; return (A) this;
    }

    public Boolean hasHttpsRedirect(){
            return this.httpsRedirect != null;
    }

    public A withNewHttpsRedirect(String arg1){
            return (A)withHttpsRedirect(new Boolean(arg1));
    }

    public A withNewHttpsRedirect(boolean arg1){
            return (A)withHttpsRedirect(new Boolean(arg1));
    }

    public me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol getMaxProtocolVersion(){
            return this.maxProtocolVersion;
    }

    public A withMaxProtocolVersion(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol maxProtocolVersion){
            this.maxProtocolVersion=maxProtocolVersion; return (A) this;
    }

    public Boolean hasMaxProtocolVersion(){
            return this.maxProtocolVersion != null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol getMinProtocolVersion(){
            return this.minProtocolVersion;
    }

    public A withMinProtocolVersion(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsProtocol minProtocolVersion){
            this.minProtocolVersion=minProtocolVersion; return (A) this;
    }

    public Boolean hasMinProtocolVersion(){
            return this.minProtocolVersion != null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsMode getMode(){
            return this.mode;
    }

    public A withMode(me.snowdrop.istio.api.networking.v1beta1.ServerTLSSettingsMode mode){
            this.mode=mode; return (A) this;
    }

    public Boolean hasMode(){
            return this.mode != null;
    }

    public String getPrivateKey(){
            return this.privateKey;
    }

    public A withPrivateKey(String privateKey){
            this.privateKey=privateKey; return (A) this;
    }

    public Boolean hasPrivateKey(){
            return this.privateKey != null;
    }

    public A withNewPrivateKey(String arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public A withNewPrivateKey(StringBuilder arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public A withNewPrivateKey(StringBuffer arg1){
            return (A)withPrivateKey(new String(arg1));
    }

    public String getServerCertificate(){
            return this.serverCertificate;
    }

    public A withServerCertificate(String serverCertificate){
            this.serverCertificate=serverCertificate; return (A) this;
    }

    public Boolean hasServerCertificate(){
            return this.serverCertificate != null;
    }

    public A withNewServerCertificate(String arg1){
            return (A)withServerCertificate(new String(arg1));
    }

    public A withNewServerCertificate(StringBuilder arg1){
            return (A)withServerCertificate(new String(arg1));
    }

    public A withNewServerCertificate(StringBuffer arg1){
            return (A)withServerCertificate(new String(arg1));
    }

    public A addToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.add(index, item);
            return (A)this;
    }

    public A setToSubjectAltNames(int index,String item){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            this.subjectAltNames.set(index, item); return (A)this;
    }

    public A addToSubjectAltNames(String... items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A addAllToSubjectAltNames(Collection<String> items){
            if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
            for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
    }

    public A removeFromSubjectAltNames(String... items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public A removeAllFromSubjectAltNames(Collection<String> items){
            for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
    }

    public List<String> getSubjectAltNames(){
            return this.subjectAltNames;
    }

    public String getSubjectAltName(int index){
            return this.subjectAltNames.get(index);
    }

    public String getFirstSubjectAltName(){
            return this.subjectAltNames.get(0);
    }

    public String getLastSubjectAltName(){
            return this.subjectAltNames.get(subjectAltNames.size() - 1);
    }

    public String getMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSubjectAltName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: subjectAltNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubjectAltNames(List<String> subjectAltNames){
            if (this.subjectAltNames != null) { _visitables.get("subjectAltNames").removeAll(this.subjectAltNames);}
            if (subjectAltNames != null) {this.subjectAltNames = new ArrayList<String>(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
    }

    public A withSubjectAltNames(String... subjectAltNames){
            if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
            if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
    }

    public Boolean hasSubjectAltNames(){
            return subjectAltNames != null && !subjectAltNames.isEmpty();
    }

    public A addNewSubjectAltName(String arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuilder arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addNewSubjectAltName(StringBuffer arg1){
            return (A)addToSubjectAltNames(new String(arg1));
    }

    public A addToVerifyCertificateHash(int index,String item){
            if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
            this.verifyCertificateHash.add(index, item);
            return (A)this;
    }

    public A setToVerifyCertificateHash(int index,String item){
            if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
            this.verifyCertificateHash.set(index, item); return (A)this;
    }

    public A addToVerifyCertificateHash(String... items){
            if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
            for (String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
    }

    public A addAllToVerifyCertificateHash(Collection<String> items){
            if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
            for (String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
    }

    public A removeFromVerifyCertificateHash(String... items){
            for (String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
    }

    public A removeAllFromVerifyCertificateHash(Collection<String> items){
            for (String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
    }

    public List<String> getVerifyCertificateHash(){
            return this.verifyCertificateHash;
    }

    public String getVerifyCertificateHash(int index){
            return this.verifyCertificateHash.get(index);
    }

    public String getFirstVerifyCertificateHash(){
            return this.verifyCertificateHash.get(0);
    }

    public String getLastVerifyCertificateHash(){
            return this.verifyCertificateHash.get(verifyCertificateHash.size() - 1);
    }

    public String getMatchingVerifyCertificateHash(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verifyCertificateHash) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVerifyCertificateHash(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verifyCertificateHash) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVerifyCertificateHash(List<String> verifyCertificateHash){
            if (this.verifyCertificateHash != null) { _visitables.get("verifyCertificateHash").removeAll(this.verifyCertificateHash);}
            if (verifyCertificateHash != null) {this.verifyCertificateHash = new ArrayList<String>(); for (String item : verifyCertificateHash){this.addToVerifyCertificateHash(item);}} else { this.verifyCertificateHash = null;} return (A) this;
    }

    public A withVerifyCertificateHash(String... verifyCertificateHash){
            if (this.verifyCertificateHash != null) {this.verifyCertificateHash.clear();}
            if (verifyCertificateHash != null) {for (String item :verifyCertificateHash){ this.addToVerifyCertificateHash(item);}} return (A) this;
    }

    public Boolean hasVerifyCertificateHash(){
            return verifyCertificateHash != null && !verifyCertificateHash.isEmpty();
    }

    public A addNewVerifyCertificateHash(String arg1){
            return (A)addToVerifyCertificateHash(new String(arg1));
    }

    public A addNewVerifyCertificateHash(StringBuilder arg1){
            return (A)addToVerifyCertificateHash(new String(arg1));
    }

    public A addNewVerifyCertificateHash(StringBuffer arg1){
            return (A)addToVerifyCertificateHash(new String(arg1));
    }

    public A addToVerifyCertificateSpki(int index,String item){
            if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
            this.verifyCertificateSpki.add(index, item);
            return (A)this;
    }

    public A setToVerifyCertificateSpki(int index,String item){
            if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
            this.verifyCertificateSpki.set(index, item); return (A)this;
    }

    public A addToVerifyCertificateSpki(String... items){
            if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
            for (String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
    }

    public A addAllToVerifyCertificateSpki(Collection<String> items){
            if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
            for (String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
    }

    public A removeFromVerifyCertificateSpki(String... items){
            for (String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
    }

    public A removeAllFromVerifyCertificateSpki(Collection<String> items){
            for (String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
    }

    public List<String> getVerifyCertificateSpki(){
            return this.verifyCertificateSpki;
    }

    public String getVerifyCertificateSpki(int index){
            return this.verifyCertificateSpki.get(index);
    }

    public String getFirstVerifyCertificateSpki(){
            return this.verifyCertificateSpki.get(0);
    }

    public String getLastVerifyCertificateSpki(){
            return this.verifyCertificateSpki.get(verifyCertificateSpki.size() - 1);
    }

    public String getMatchingVerifyCertificateSpki(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verifyCertificateSpki) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingVerifyCertificateSpki(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: verifyCertificateSpki) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withVerifyCertificateSpki(List<String> verifyCertificateSpki){
            if (this.verifyCertificateSpki != null) { _visitables.get("verifyCertificateSpki").removeAll(this.verifyCertificateSpki);}
            if (verifyCertificateSpki != null) {this.verifyCertificateSpki = new ArrayList<String>(); for (String item : verifyCertificateSpki){this.addToVerifyCertificateSpki(item);}} else { this.verifyCertificateSpki = null;} return (A) this;
    }

    public A withVerifyCertificateSpki(String... verifyCertificateSpki){
            if (this.verifyCertificateSpki != null) {this.verifyCertificateSpki.clear();}
            if (verifyCertificateSpki != null) {for (String item :verifyCertificateSpki){ this.addToVerifyCertificateSpki(item);}} return (A) this;
    }

    public Boolean hasVerifyCertificateSpki(){
            return verifyCertificateSpki != null && !verifyCertificateSpki.isEmpty();
    }

    public A addNewVerifyCertificateSpki(String arg1){
            return (A)addToVerifyCertificateSpki(new String(arg1));
    }

    public A addNewVerifyCertificateSpki(StringBuilder arg1){
            return (A)addToVerifyCertificateSpki(new String(arg1));
    }

    public A addNewVerifyCertificateSpki(StringBuffer arg1){
            return (A)addToVerifyCertificateSpki(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ServerTLSSettingsFluentImpl that = (ServerTLSSettingsFluentImpl) o;
            if (caCertificates != null ? !caCertificates.equals(that.caCertificates) :that.caCertificates != null) return false;
            if (cipherSuites != null ? !cipherSuites.equals(that.cipherSuites) :that.cipherSuites != null) return false;
            if (credentialName != null ? !credentialName.equals(that.credentialName) :that.credentialName != null) return false;
            if (httpsRedirect != null ? !httpsRedirect.equals(that.httpsRedirect) :that.httpsRedirect != null) return false;
            if (maxProtocolVersion != null ? !maxProtocolVersion.equals(that.maxProtocolVersion) :that.maxProtocolVersion != null) return false;
            if (minProtocolVersion != null ? !minProtocolVersion.equals(that.minProtocolVersion) :that.minProtocolVersion != null) return false;
            if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
            if (privateKey != null ? !privateKey.equals(that.privateKey) :that.privateKey != null) return false;
            if (serverCertificate != null ? !serverCertificate.equals(that.serverCertificate) :that.serverCertificate != null) return false;
            if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
            if (verifyCertificateHash != null ? !verifyCertificateHash.equals(that.verifyCertificateHash) :that.verifyCertificateHash != null) return false;
            if (verifyCertificateSpki != null ? !verifyCertificateSpki.equals(that.verifyCertificateSpki) :that.verifyCertificateSpki != null) return false;
            return true;
    }




}
