package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ServiceEntrySpecBuilder extends me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluentImpl<me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec,me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceEntrySpecBuilder(){
            this(true);
    }
    public ServiceEntrySpecBuilder(Boolean validationEnabled){
            this(new ServiceEntrySpec(), validationEnabled);
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent<?> fluent){
            this(fluent, true);
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ServiceEntrySpec(), validationEnabled);
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec instance){
            this(fluent, instance, true);
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpecFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddresses(instance.getAddresses()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withExportTo(instance.getExportTo()); 
            fluent.withHosts(instance.getHosts()); 
            fluent.withLocation(instance.getLocation()); 
            fluent.withPorts(instance.getPorts()); 
            fluent.withResolution(instance.getResolution()); 
            fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
            fluent.withWorkloadSelector(instance.getWorkloadSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec instance){
            this(instance,true);
    }
    public ServiceEntrySpecBuilder(me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddresses(instance.getAddresses()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withExportTo(instance.getExportTo()); 
            this.withHosts(instance.getHosts()); 
            this.withLocation(instance.getLocation()); 
            this.withPorts(instance.getPorts()); 
            this.withResolution(instance.getResolution()); 
            this.withSubjectAltNames(instance.getSubjectAltNames()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.ServiceEntrySpec build(){
            ServiceEntrySpec buildable = new ServiceEntrySpec(fluent.getAddresses(),fluent.getEndpoints(),fluent.getExportTo(),fluent.getHosts(),fluent.getLocation(),fluent.getPorts(),fluent.getResolution(),fluent.getSubjectAltNames(),fluent.getWorkloadSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ServiceEntrySpecBuilder that = (ServiceEntrySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
