
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "egress",
    "ingress",
    "outboundTrafficPolicy",
    "workloadSelector"
})
@IstioKind(name = "Sidecar", plural = "sidecars")
@IstioApiVersion("networking.istio.io/v1beta1")
@Version("v1beta1")
@Group("networking.istio.io")
@Plural("sidecars")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class SidecarSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("egress")
    @JsonPropertyDescription("")
    private List<IstioEgressListener> egress = new ArrayList<IstioEgressListener>();
    /**
     * 
     */
    @JsonProperty("ingress")
    @JsonPropertyDescription("")
    private List<IstioIngressListener> ingress = new ArrayList<IstioIngressListener>();
    /**
     * 
     */
    @JsonProperty("outboundTrafficPolicy")
    @JsonPropertyDescription("")
    private OutboundTrafficPolicy outboundTrafficPolicy;
    /**
     * 
     */
    @JsonProperty("workloadSelector")
    @JsonPropertyDescription("")
    private WorkloadSelector workloadSelector;
    private final static long serialVersionUID = 6531295862445364132L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SidecarSpec() {
    }

    /**
     * 
     * @param ingress
     * @param workloadSelector
     * @param outboundTrafficPolicy
     * @param egress
     */
    public SidecarSpec(List<IstioEgressListener> egress, List<IstioIngressListener> ingress, OutboundTrafficPolicy outboundTrafficPolicy, WorkloadSelector workloadSelector) {
        super();
        this.egress = egress;
        this.ingress = ingress;
        this.outboundTrafficPolicy = outboundTrafficPolicy;
        this.workloadSelector = workloadSelector;
    }

    /**
     * 
     */
    public List<IstioEgressListener> getEgress() {
        return egress;
    }

    /**
     * 
     */
    public void setEgress(List<IstioEgressListener> egress) {
        this.egress = egress;
    }

    /**
     * 
     */
    public List<IstioIngressListener> getIngress() {
        return ingress;
    }

    /**
     * 
     */
    public void setIngress(List<IstioIngressListener> ingress) {
        this.ingress = ingress;
    }

    /**
     * 
     */
    public OutboundTrafficPolicy getOutboundTrafficPolicy() {
        return outboundTrafficPolicy;
    }

    /**
     * 
     */
    public void setOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
        this.outboundTrafficPolicy = outboundTrafficPolicy;
    }

    /**
     * 
     */
    public WorkloadSelector getWorkloadSelector() {
        return workloadSelector;
    }

    /**
     * 
     */
    public void setWorkloadSelector(WorkloadSelector workloadSelector) {
        this.workloadSelector = workloadSelector;
    }

}
