package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class SidecarSpecFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.SidecarSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.SidecarSpecFluent<A>{

    private List<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> egress;
    private List<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> ingress;
    private me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder outboundTrafficPolicy;
    private me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder workloadSelector;

    public SidecarSpecFluentImpl(){
    }
    public SidecarSpecFluentImpl(me.snowdrop.istio.api.networking.v1beta1.SidecarSpec instance){
            this.withEgress(instance.getEgress()); 
            this.withIngress(instance.getIngress()); 
            this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
            this.withWorkloadSelector(instance.getWorkloadSelector()); 
    }

    public A addToEgress(int index,me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item){
            if (this.egress == null) {this.egress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(index >= 0 ? index : _visitables.get("egress").size(), builder);this.egress.add(index >= 0 ? index : egress.size(), builder); return (A)this;
    }

    public A setToEgress(int index,me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item){
            if (this.egress == null) {this.egress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);
            if (index < 0 || index >= _visitables.get("egress").size()) { _visitables.get("egress").add(builder); } else { _visitables.get("egress").set(index, builder);}
            if (index < 0 || index >= egress.size()) { egress.add(builder); } else { egress.set(index, builder);}
             return (A)this;
    }

    public A addToEgress(me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener... items){
            if (this.egress == null) {this.egress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A addAllToEgress(Collection<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener> items){
            if (this.egress == null) {this.egress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
    }

    public A removeFromEgress(me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener... items){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeAllFromEgress(Collection<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener> items){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder);if (this.egress != null) {this.egress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEgress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate){
            if (egress == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> each = egress.iterator();
            final List visitables = _visitables.get("egress");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildEgress instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener> getEgress(){
            return build(egress);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener> buildEgress(){
            return build(egress);
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener buildEgress(int index){
            return this.egress.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener buildFirstEgress(){
            return this.egress.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener buildLastEgress(){
            return this.egress.get(egress.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener buildMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder item: egress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder item: egress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withEgress(List<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener> egress){
            if (this.egress != null) { _visitables.get("egress").removeAll(this.egress);}
            if (egress != null) {this.egress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item : egress){this.addToEgress(item);}} else { this.egress = null;} return (A) this;
    }

    public A withEgress(me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener... egress){
            if (this.egress != null) {this.egress.clear();}
            if (egress != null) {for (me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item :egress){ this.addToEgress(item);}} return (A) this;
    }

    public Boolean hasEgress(){
            return egress != null && !egress.isEmpty();
    }

    public SidecarSpecFluent.EgressNested<A> addNewEgress(){
            return new EgressNestedImpl();
    }

    public SidecarSpecFluent.EgressNested<A> addNewEgressLike(me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item){
            return new EgressNestedImpl(-1, item);
    }

    public SidecarSpecFluent.EgressNested<A> setNewEgressLike(int index,me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item){
            return new EgressNestedImpl(index, item);
    }

    public SidecarSpecFluent.EgressNested<A> editEgress(int index){
            if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public SidecarSpecFluent.EgressNested<A> editFirstEgress(){
            if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
            return setNewEgressLike(0, buildEgress(0));
    }

    public SidecarSpecFluent.EgressNested<A> editLastEgress(){
            int index = egress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public SidecarSpecFluent.EgressNested<A> editMatchingEgress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder> predicate){
            int index = -1;
            for (int i=0;i<egress.size();i++) { 
            if (predicate.apply(egress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
            return setNewEgressLike(index, buildEgress(index));
    }

    public A addToIngress(int index,me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item){
            if (this.ingress == null) {this.ingress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
    }

    public A setToIngress(int index,me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item){
            if (this.ingress == null) {this.ingress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);
            if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
            if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
             return (A)this;
    }

    public A addToIngress(me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener... items){
            if (this.ingress == null) {this.ingress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A addAllToIngress(Collection<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener> items){
            if (this.ingress == null) {this.ingress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
    }

    public A removeFromIngress(me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener... items){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeAllFromIngress(Collection<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener> items){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item : items) {me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIngress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate){
            if (ingress == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> each = ingress.iterator();
            final List visitables = _visitables.get("ingress");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIngress instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener> getIngress(){
            return build(ingress);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener> buildIngress(){
            return build(ingress);
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener buildIngress(int index){
            return this.ingress.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener buildFirstIngress(){
            return this.ingress.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener buildLastIngress(){
            return this.ingress.get(ingress.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener buildMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder item: ingress) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder item: ingress) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withIngress(List<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener> ingress){
            if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
            if (ingress != null) {this.ingress = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
    }

    public A withIngress(me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener... ingress){
            if (this.ingress != null) {this.ingress.clear();}
            if (ingress != null) {for (me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item :ingress){ this.addToIngress(item);}} return (A) this;
    }

    public Boolean hasIngress(){
            return ingress != null && !ingress.isEmpty();
    }

    public SidecarSpecFluent.IngressNested<A> addNewIngress(){
            return new IngressNestedImpl();
    }

    public SidecarSpecFluent.IngressNested<A> addNewIngressLike(me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item){
            return new IngressNestedImpl(-1, item);
    }

    public SidecarSpecFluent.IngressNested<A> setNewIngressLike(int index,me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item){
            return new IngressNestedImpl(index, item);
    }

    public SidecarSpecFluent.IngressNested<A> editIngress(int index){
            if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public SidecarSpecFluent.IngressNested<A> editFirstIngress(){
            if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
            return setNewIngressLike(0, buildIngress(0));
    }

    public SidecarSpecFluent.IngressNested<A> editLastIngress(){
            int index = ingress.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
            return setNewIngressLike(index, buildIngress(index));
    }

    public SidecarSpecFluent.IngressNested<A> editMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder> predicate){
            int index = -1;
            for (int i=0;i<ingress.size();i++) { 
            if (predicate.apply(ingress.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
            return setNewIngressLike(index, buildIngress(index));
    }

    
/**
 * This method has been deprecated, please use method buildOutboundTrafficPolicy instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy getOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy buildOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy!=null?this.outboundTrafficPolicy.build():null;
    }

    public A withOutboundTrafficPolicy(me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy outboundTrafficPolicy){
            _visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
            if (outboundTrafficPolicy!=null){ this.outboundTrafficPolicy= new me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder(outboundTrafficPolicy); _visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);} return (A) this;
    }

    public Boolean hasOutboundTrafficPolicy(){
            return this.outboundTrafficPolicy != null;
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy(){
            return new OutboundTrafficPolicyNestedImpl();
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy item){
            return new OutboundTrafficPolicyNestedImpl(item);
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy());
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy(){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): new me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder().build());
    }

    public SidecarSpecFluent.OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy item){
            return withNewOutboundTrafficPolicyLike(getOutboundTrafficPolicy() != null ? getOutboundTrafficPolicy(): item);
    }

    
/**
 * This method has been deprecated, please use method buildWorkloadSelector instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector getWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector buildWorkloadSelector(){
            return this.workloadSelector!=null?this.workloadSelector.build():null;
    }

    public A withWorkloadSelector(me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector workloadSelector){
            _visitables.get("workloadSelector").remove(this.workloadSelector);
            if (workloadSelector!=null){ this.workloadSelector= new me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} return (A) this;
    }

    public Boolean hasWorkloadSelector(){
            return this.workloadSelector != null;
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector(){
            return new WorkloadSelectorNestedImpl();
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector item){
            return new WorkloadSelectorNestedImpl(item);
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector());
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector(){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder().build());
    }

    public SidecarSpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector item){
            return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            SidecarSpecFluentImpl that = (SidecarSpecFluentImpl) o;
            if (egress != null ? !egress.equals(that.egress) :that.egress != null) return false;
            if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
            if (outboundTrafficPolicy != null ? !outboundTrafficPolicy.equals(that.outboundTrafficPolicy) :that.outboundTrafficPolicy != null) return false;
            if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
            return true;
    }


    public class EgressNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerFluentImpl<SidecarSpecFluent.EgressNested<N>> implements SidecarSpecFluent.EgressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder builder;
        private final int index;
    
            EgressNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.IstioEgressListener item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(this, item);
            }
            EgressNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.IstioEgressListenerBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.setToEgress(index,builder.build());
    }
    public N endEgress(){
            return and();
    }

}
    public class IngressNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerFluentImpl<SidecarSpecFluent.IngressNested<N>> implements SidecarSpecFluent.IngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder builder;
        private final int index;
    
            IngressNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.IstioIngressListener item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(this, item);
            }
            IngressNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.IstioIngressListenerBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress(){
            return and();
    }

}
    public class OutboundTrafficPolicyNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyFluentImpl<SidecarSpecFluent.OutboundTrafficPolicyNested<N>> implements SidecarSpecFluent.OutboundTrafficPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder builder;
    
            OutboundTrafficPolicyNestedImpl(me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicy item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder(this, item);
            }
            OutboundTrafficPolicyNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutboundTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.withOutboundTrafficPolicy(builder.build());
    }
    public N endOutboundTrafficPolicy(){
            return and();
    }

}
    public class WorkloadSelectorNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorFluentImpl<SidecarSpecFluent.WorkloadSelectorNested<N>> implements SidecarSpecFluent.WorkloadSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder builder;
    
            WorkloadSelectorNestedImpl(me.snowdrop.istio.api.networking.v1beta1.WorkloadSelector item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder(this, item);
            }
            WorkloadSelectorNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) SidecarSpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector(){
            return and();
    }

}


}
