
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings.LbPolicy;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "simple"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class SimpleLbPolicy implements Serializable, LbPolicy
{

    @JsonProperty("simple")
    private SimpleLB simple;
    private final static long serialVersionUID = 832156902380300012L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public SimpleLbPolicy() {
    }

    /**
     * 
     * @param simple
     */
    public SimpleLbPolicy(SimpleLB simple) {
        super();
        this.simple = simple;
    }

    public SimpleLB getSimple() {
        return simple;
    }

    public void setSimple(SimpleLB simple) {
        this.simple = simple;
    }

}
