
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "matchType"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class StringMatch implements Serializable
{

    @JsonProperty("matchType")
    @JsonUnwrapped
    private me.snowdrop.istio.api.networking.v1beta1.StringMatch.MatchType matchType;
    private final static long serialVersionUID = -8503361184326500619L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public StringMatch() {
    }

    /**
     * 
     * @param matchType
     */
    public StringMatch(me.snowdrop.istio.api.networking.v1beta1.StringMatch.MatchType matchType) {
        super();
        this.matchType = matchType;
    }

    public me.snowdrop.istio.api.networking.v1beta1.StringMatch.MatchType getMatchType() {
        return matchType;
    }

    public void setMatchType(me.snowdrop.istio.api.networking.v1beta1.StringMatch.MatchType matchType) {
        this.matchType = matchType;
    }

    public interface MatchType extends Serializable
    {


    }

}
