
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "match",
    "route"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TCPRoute implements Serializable
{

    /**
     * 
     */
    @JsonProperty("match")
    @JsonPropertyDescription("")
    private List<L4MatchAttributes> match = new ArrayList<L4MatchAttributes>();
    /**
     * 
     */
    @JsonProperty("route")
    @JsonPropertyDescription("")
    private List<RouteDestination> route = new ArrayList<RouteDestination>();
    private final static long serialVersionUID = 4656846106514395273L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TCPRoute() {
    }

    /**
     * 
     * @param route
     * @param match
     */
    public TCPRoute(List<L4MatchAttributes> match, List<RouteDestination> route) {
        super();
        this.match = match;
        this.route = route;
    }

    /**
     * 
     */
    public List<L4MatchAttributes> getMatch() {
        return match;
    }

    /**
     * 
     */
    public void setMatch(List<L4MatchAttributes> match) {
        this.match = match;
    }

    /**
     * 
     */
    public List<RouteDestination> getRoute() {
        return route;
    }

    /**
     * 
     */
    public void setRoute(List<RouteDestination> route) {
        this.route = route;
    }

}
