
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.Duration;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectTimeout",
    "maxConnections",
    "tcpKeepalive"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TCPSettings implements Serializable
{

    /**
     * 
     */
    @JsonProperty("connectTimeout")
    @JsonPropertyDescription("")
    private Duration connectTimeout;
    /**
     * 
     */
    @JsonProperty("maxConnections")
    @JsonPropertyDescription("")
    private Integer maxConnections;
    /**
     * 
     */
    @JsonProperty("tcpKeepalive")
    @JsonPropertyDescription("")
    private TcpKeepalive tcpKeepalive;
    private final static long serialVersionUID = -8929304481683270306L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TCPSettings() {
    }

    /**
     * 
     * @param tcpKeepalive
     * @param connectTimeout
     * @param maxConnections
     */
    public TCPSettings(Duration connectTimeout, Integer maxConnections, TcpKeepalive tcpKeepalive) {
        super();
        this.connectTimeout = connectTimeout;
        this.maxConnections = maxConnections;
        this.tcpKeepalive = tcpKeepalive;
    }

    /**
     * 
     */
    public Duration getConnectTimeout() {
        return connectTimeout;
    }

    /**
     * 
     */
    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    /**
     * 
     */
    public Integer getMaxConnections() {
        return maxConnections;
    }

    /**
     * 
     */
    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    /**
     * 
     */
    public TcpKeepalive getTcpKeepalive() {
        return tcpKeepalive;
    }

    /**
     * 
     */
    public void setTcpKeepalive(TcpKeepalive tcpKeepalive) {
        this.tcpKeepalive = tcpKeepalive;
    }

}
