package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TCPSettingsBuilder extends me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluentImpl<me.snowdrop.istio.api.networking.v1beta1.TCPSettingsBuilder> implements VisitableBuilder<me.snowdrop.istio.api.networking.v1beta1.TCPSettings,me.snowdrop.istio.api.networking.v1beta1.TCPSettingsBuilder>{

    me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluent<?> fluent;
    Boolean validationEnabled;

    public TCPSettingsBuilder(){
            this(true);
    }
    public TCPSettingsBuilder(Boolean validationEnabled){
            this(new TCPSettings(), validationEnabled);
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluent<?> fluent){
            this(fluent, true);
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TCPSettings(), validationEnabled);
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.TCPSettings instance){
            this(fluent, instance, true);
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettingsFluent<?> fluent,me.snowdrop.istio.api.networking.v1beta1.TCPSettings instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectTimeout(instance.getConnectTimeout()); 
            fluent.withMaxConnections(instance.getMaxConnections()); 
            fluent.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.validationEnabled = validationEnabled; 
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettings instance){
            this(instance,true);
    }
    public TCPSettingsBuilder(me.snowdrop.istio.api.networking.v1beta1.TCPSettings instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectTimeout(instance.getConnectTimeout()); 
            this.withMaxConnections(instance.getMaxConnections()); 
            this.withTcpKeepalive(instance.getTcpKeepalive()); 
            this.validationEnabled = validationEnabled; 
    }

    public me.snowdrop.istio.api.networking.v1beta1.TCPSettings build(){
            TCPSettings buildable = new TCPSettings(fluent.getConnectTimeout(),fluent.getMaxConnections(),fluent.getTcpKeepalive());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TCPSettingsBuilder that = (TCPSettingsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
