
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "destinationSubnets",
    "gateways",
    "port",
    "sniHosts",
    "sourceLabels",
    "sourceNamespace"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TLSMatchAttributes implements Serializable
{

    /**
     * 
     */
    @JsonProperty("destinationSubnets")
    @JsonPropertyDescription("")
    private List<java.lang.String> destinationSubnets = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("gateways")
    @JsonPropertyDescription("")
    private List<java.lang.String> gateways = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("port")
    @JsonPropertyDescription("")
    private Integer port;
    /**
     * 
     */
    @JsonProperty("sniHosts")
    @JsonPropertyDescription("")
    private List<java.lang.String> sniHosts = new ArrayList<java.lang.String>();
    /**
     * 
     */
    @JsonProperty("sourceLabels")
    @JsonPropertyDescription("")
    private Map<String, String> sourceLabels;
    /**
     * 
     */
    @JsonProperty("sourceNamespace")
    @JsonPropertyDescription("")
    private java.lang.String sourceNamespace;
    private final static long serialVersionUID = 4634275057355669304L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TLSMatchAttributes() {
    }

    /**
     * 
     * @param gateways
     * @param sniHosts
     * @param destinationSubnets
     * @param port
     * @param sourceLabels
     * @param sourceNamespace
     */
    public TLSMatchAttributes(List<java.lang.String> destinationSubnets, List<java.lang.String> gateways, Integer port, List<java.lang.String> sniHosts, Map<String, String> sourceLabels, java.lang.String sourceNamespace) {
        super();
        this.destinationSubnets = destinationSubnets;
        this.gateways = gateways;
        this.port = port;
        this.sniHosts = sniHosts;
        this.sourceLabels = sourceLabels;
        this.sourceNamespace = sourceNamespace;
    }

    /**
     * 
     */
    public List<java.lang.String> getDestinationSubnets() {
        return destinationSubnets;
    }

    /**
     * 
     */
    public void setDestinationSubnets(List<java.lang.String> destinationSubnets) {
        this.destinationSubnets = destinationSubnets;
    }

    /**
     * 
     */
    public List<java.lang.String> getGateways() {
        return gateways;
    }

    /**
     * 
     */
    public void setGateways(List<java.lang.String> gateways) {
        this.gateways = gateways;
    }

    /**
     * 
     */
    public Integer getPort() {
        return port;
    }

    /**
     * 
     */
    public void setPort(Integer port) {
        this.port = port;
    }

    /**
     * 
     */
    public List<java.lang.String> getSniHosts() {
        return sniHosts;
    }

    /**
     * 
     */
    public void setSniHosts(List<java.lang.String> sniHosts) {
        this.sniHosts = sniHosts;
    }

    /**
     * 
     */
    public Map<String, String> getSourceLabels() {
        return sourceLabels;
    }

    /**
     * 
     */
    public void setSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels;
    }

    /**
     * 
     */
    public java.lang.String getSourceNamespace() {
        return sourceNamespace;
    }

    /**
     * 
     */
    public void setSourceNamespace(java.lang.String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
    }

}
