
package me.snowdrop.istio.api.networking.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "connectionPool",
    "loadBalancer",
    "outlierDetection",
    "portLevelSettings",
    "tls"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class TrafficPolicy implements Serializable
{

    /**
     * 
     */
    @JsonProperty("connectionPool")
    @JsonPropertyDescription("")
    private ConnectionPoolSettings connectionPool;
    /**
     * 
     */
    @JsonProperty("loadBalancer")
    @JsonPropertyDescription("")
    private LoadBalancerSettings loadBalancer;
    /**
     * 
     */
    @JsonProperty("outlierDetection")
    @JsonPropertyDescription("")
    private OutlierDetection outlierDetection;
    /**
     * 
     */
    @JsonProperty("portLevelSettings")
    @JsonPropertyDescription("")
    private List<PortTrafficPolicy> portLevelSettings = new ArrayList<PortTrafficPolicy>();
    /**
     * 
     */
    @JsonProperty("tls")
    @JsonPropertyDescription("")
    private ClientTLSSettings tls;
    private final static long serialVersionUID = 6222994298249295364L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public TrafficPolicy() {
    }

    /**
     * 
     * @param loadBalancer
     * @param portLevelSettings
     * @param connectionPool
     * @param tls
     * @param outlierDetection
     */
    public TrafficPolicy(ConnectionPoolSettings connectionPool, LoadBalancerSettings loadBalancer, OutlierDetection outlierDetection, List<PortTrafficPolicy> portLevelSettings, ClientTLSSettings tls) {
        super();
        this.connectionPool = connectionPool;
        this.loadBalancer = loadBalancer;
        this.outlierDetection = outlierDetection;
        this.portLevelSettings = portLevelSettings;
        this.tls = tls;
    }

    /**
     * 
     */
    public ConnectionPoolSettings getConnectionPool() {
        return connectionPool;
    }

    /**
     * 
     */
    public void setConnectionPool(ConnectionPoolSettings connectionPool) {
        this.connectionPool = connectionPool;
    }

    /**
     * 
     */
    public LoadBalancerSettings getLoadBalancer() {
        return loadBalancer;
    }

    /**
     * 
     */
    public void setLoadBalancer(LoadBalancerSettings loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    /**
     * 
     */
    public OutlierDetection getOutlierDetection() {
        return outlierDetection;
    }

    /**
     * 
     */
    public void setOutlierDetection(OutlierDetection outlierDetection) {
        this.outlierDetection = outlierDetection;
    }

    /**
     * 
     */
    public List<PortTrafficPolicy> getPortLevelSettings() {
        return portLevelSettings;
    }

    /**
     * 
     */
    public void setPortLevelSettings(List<PortTrafficPolicy> portLevelSettings) {
        this.portLevelSettings = portLevelSettings;
    }

    /**
     * 
     */
    public ClientTLSSettings getTls() {
        return tls;
    }

    /**
     * 
     */
    public void setTls(ClientTLSSettings tls) {
        this.tls = tls;
    }

}
