package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class TrafficPolicyFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.TrafficPolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.TrafficPolicyFluent<A>{

    private me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder connectionPool;
    private me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder loadBalancer;
    private me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder outlierDetection;
    private List<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> portLevelSettings;
    private me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder tls;

    public TrafficPolicyFluentImpl(){
    }
    public TrafficPolicyFluentImpl(me.snowdrop.istio.api.networking.v1beta1.TrafficPolicy instance){
            this.withConnectionPool(instance.getConnectionPool()); 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.withOutlierDetection(instance.getOutlierDetection()); 
            this.withPortLevelSettings(instance.getPortLevelSettings()); 
            this.withTls(instance.getTls()); 
    }

    
/**
 * This method has been deprecated, please use method buildConnectionPool instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings getConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings buildConnectionPool(){
            return this.connectionPool!=null?this.connectionPool.build():null;
    }

    public A withConnectionPool(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings connectionPool){
            _visitables.get("connectionPool").remove(this.connectionPool);
            if (connectionPool!=null){ this.connectionPool= new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} return (A) this;
    }

    public Boolean hasConnectionPool(){
            return this.connectionPool != null;
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool(){
            return new ConnectionPoolNestedImpl();
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
            return new ConnectionPoolNestedImpl(item);
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool());
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool(){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder().build());
    }

    public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
            return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings buildLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings loadBalancer){
            _visitables.get("loadBalancer").remove(this.loadBalancer);
            if (loadBalancer!=null){ this.loadBalancer= new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer(){
            return this.loadBalancer != null;
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
            return new LoadBalancerNestedImpl(item);
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder().build());
    }

    public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOutlierDetection instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.OutlierDetection getOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.OutlierDetection buildOutlierDetection(){
            return this.outlierDetection!=null?this.outlierDetection.build():null;
    }

    public A withOutlierDetection(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection outlierDetection){
            _visitables.get("outlierDetection").remove(this.outlierDetection);
            if (outlierDetection!=null){ this.outlierDetection= new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} return (A) this;
    }

    public Boolean hasOutlierDetection(){
            return this.outlierDetection != null;
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection(){
            return new OutlierDetectionNestedImpl();
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
            return new OutlierDetectionNestedImpl(item);
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection());
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection(){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder().build());
    }

    public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
            return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
    }

    public A addToPortLevelSettings(int index,me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(index >= 0 ? index : _visitables.get("portLevelSettings").size(), builder);this.portLevelSettings.add(index >= 0 ? index : portLevelSettings.size(), builder); return (A)this;
    }

    public A setToPortLevelSettings(int index,me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);
            if (index < 0 || index >= _visitables.get("portLevelSettings").size()) { _visitables.get("portLevelSettings").add(builder); } else { _visitables.get("portLevelSettings").set(index, builder);}
            if (index < 0 || index >= portLevelSettings.size()) { portLevelSettings.add(builder); } else { portLevelSettings.set(index, builder);}
             return (A)this;
    }

    public A addToPortLevelSettings(me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy... items){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item : items) {me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
    }

    public A addAllToPortLevelSettings(Collection<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy> items){
            if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item : items) {me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
    }

    public A removeFromPortLevelSettings(me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy... items){
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item : items) {me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
    }

    public A removeAllFromPortLevelSettings(Collection<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy> items){
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item : items) {me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPortLevelSettings(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> predicate){
            if (portLevelSettings == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> each = portLevelSettings.iterator();
            final List visitables = _visitables.get("portLevelSettings");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPortLevelSettings instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy> getPortLevelSettings(){
            return build(portLevelSettings);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy> buildPortLevelSettings(){
            return build(portLevelSettings);
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy buildPortLevelSetting(int index){
            return this.portLevelSettings.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy buildFirstPortLevelSetting(){
            return this.portLevelSettings.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy buildLastPortLevelSetting(){
            return this.portLevelSettings.get(portLevelSettings.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy buildMatchingPortLevelSetting(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPortLevelSetting(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPortLevelSettings(List<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy> portLevelSettings){
            if (this.portLevelSettings != null) { _visitables.get("portLevelSettings").removeAll(this.portLevelSettings);}
            if (portLevelSettings != null) {this.portLevelSettings = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item : portLevelSettings){this.addToPortLevelSettings(item);}} else { this.portLevelSettings = null;} return (A) this;
    }

    public A withPortLevelSettings(me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy... portLevelSettings){
            if (this.portLevelSettings != null) {this.portLevelSettings.clear();}
            if (portLevelSettings != null) {for (me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item :portLevelSettings){ this.addToPortLevelSettings(item);}} return (A) this;
    }

    public Boolean hasPortLevelSettings(){
            return portLevelSettings != null && !portLevelSettings.isEmpty();
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSetting(){
            return new PortLevelSettingsNestedImpl();
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSettingLike(me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item){
            return new PortLevelSettingsNestedImpl(-1, item);
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> setNewPortLevelSettingLike(int index,me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item){
            return new PortLevelSettingsNestedImpl(index, item);
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editPortLevelSetting(int index){
            if (portLevelSettings.size() <= index) throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editFirstPortLevelSetting(){
            if (portLevelSettings.size() == 0) throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
            return setNewPortLevelSettingLike(0, buildPortLevelSetting(0));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editLastPortLevelSetting(){
            int index = portLevelSettings.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    public TrafficPolicyFluent.PortLevelSettingsNested<A> editMatchingPortLevelSetting(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder> predicate){
            int index = -1;
            for (int i=0;i<portLevelSettings.size();i++) { 
            if (predicate.apply(portLevelSettings.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
            return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public TrafficPolicyFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public TrafficPolicyFluent.TlsNested<A> withNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
            return new TlsNestedImpl(item);
    }

    public TrafficPolicyFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public TrafficPolicyFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder().build());
    }

    public TrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            TrafficPolicyFluentImpl that = (TrafficPolicyFluentImpl) o;
            if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
            if (portLevelSettings != null ? !portLevelSettings.equals(that.portLevelSettings) :that.portLevelSettings != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class ConnectionPoolNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsFluentImpl<TrafficPolicyFluent.ConnectionPoolNested<N>> implements TrafficPolicyFluent.ConnectionPoolNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder builder;
    
            ConnectionPoolNestedImpl(me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(this, item);
            }
            ConnectionPoolNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ConnectionPoolSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool(){
            return and();
    }

}
    public class LoadBalancerNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsFluentImpl<TrafficPolicyFluent.LoadBalancerNested<N>> implements TrafficPolicyFluent.LoadBalancerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder builder;
    
            LoadBalancerNestedImpl(me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(this, item);
            }
            LoadBalancerNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.LoadBalancerSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}
    public class OutlierDetectionNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionFluentImpl<TrafficPolicyFluent.OutlierDetectionNested<N>> implements TrafficPolicyFluent.OutlierDetectionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder builder;
    
            OutlierDetectionNestedImpl(me.snowdrop.istio.api.networking.v1beta1.OutlierDetection item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(this, item);
            }
            OutlierDetectionNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.OutlierDetectionBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection(){
            return and();
    }

}
    public class PortLevelSettingsNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyFluentImpl<TrafficPolicyFluent.PortLevelSettingsNested<N>> implements TrafficPolicyFluent.PortLevelSettingsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder builder;
        private final int index;
    
            PortLevelSettingsNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicy item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(this, item);
            }
            PortLevelSettingsNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.PortTrafficPolicyBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.setToPortLevelSettings(index,builder.build());
    }
    public N endPortLevelSetting(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsFluentImpl<TrafficPolicyFluent.TlsNested<N>> implements TrafficPolicyFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder builder;
    
            TlsNestedImpl(me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettings item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.ClientTLSSettingsBuilder(this);
            }
    
    public N and(){
            return (N) TrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}


}
