package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class VirtualServiceSpecFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.VirtualServiceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.VirtualServiceSpecFluent<A>{

    private List<String> exportTo;
    private List<String> gateways;
    private List<String> hosts;
    private List<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> http;
    private List<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> tcp;
    private List<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> tls;

    public VirtualServiceSpecFluentImpl(){
    }
    public VirtualServiceSpecFluentImpl(me.snowdrop.istio.api.networking.v1beta1.VirtualServiceSpec instance){
            this.withExportTo(instance.getExportTo()); 
            this.withGateways(instance.getGateways()); 
            this.withHosts(instance.getHosts()); 
            this.withHttp(instance.getHttp()); 
            this.withTcp(instance.getTcp()); 
            this.withTls(instance.getTls()); 
    }

    public A addToExportTo(int index,String item){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            this.exportTo.add(index, item);
            return (A)this;
    }

    public A setToExportTo(int index,String item){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            this.exportTo.set(index, item); return (A)this;
    }

    public A addToExportTo(String... items){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            for (String item : items) {this.exportTo.add(item);} return (A)this;
    }

    public A addAllToExportTo(Collection<String> items){
            if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
            for (String item : items) {this.exportTo.add(item);} return (A)this;
    }

    public A removeFromExportTo(String... items){
            for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
    }

    public A removeAllFromExportTo(Collection<String> items){
            for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
    }

    public List<String> getExportTo(){
            return this.exportTo;
    }

    public String getExportTo(int index){
            return this.exportTo.get(index);
    }

    public String getFirstExportTo(){
            return this.exportTo.get(0);
    }

    public String getLastExportTo(){
            return this.exportTo.get(exportTo.size() - 1);
    }

    public String getMatchingExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exportTo) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingExportTo(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: exportTo) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withExportTo(List<String> exportTo){
            if (this.exportTo != null) { _visitables.get("exportTo").removeAll(this.exportTo);}
            if (exportTo != null) {this.exportTo = new ArrayList<String>(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
    }

    public A withExportTo(String... exportTo){
            if (this.exportTo != null) {this.exportTo.clear();}
            if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
    }

    public Boolean hasExportTo(){
            return exportTo != null && !exportTo.isEmpty();
    }

    public A addNewExportTo(String arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addNewExportTo(StringBuilder arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addNewExportTo(StringBuffer arg1){
            return (A)addToExportTo(new String(arg1));
    }

    public A addToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.add(index, item);
            return (A)this;
    }

    public A setToGateways(int index,String item){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            this.gateways.set(index, item); return (A)this;
    }

    public A addToGateways(String... items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A addAllToGateways(Collection<String> items){
            if (this.gateways == null) {this.gateways = new ArrayList<String>();}
            for (String item : items) {this.gateways.add(item);} return (A)this;
    }

    public A removeFromGateways(String... items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public A removeAllFromGateways(Collection<String> items){
            for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
    }

    public List<String> getGateways(){
            return this.gateways;
    }

    public String getGateway(int index){
            return this.gateways.get(index);
    }

    public String getFirstGateway(){
            return this.gateways.get(0);
    }

    public String getLastGateway(){
            return this.gateways.get(gateways.size() - 1);
    }

    public String getMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGateway(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: gateways) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGateways(List<String> gateways){
            if (this.gateways != null) { _visitables.get("gateways").removeAll(this.gateways);}
            if (gateways != null) {this.gateways = new ArrayList<String>(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
    }

    public A withGateways(String... gateways){
            if (this.gateways != null) {this.gateways.clear();}
            if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
    }

    public Boolean hasGateways(){
            return gateways != null && !gateways.isEmpty();
    }

    public A addNewGateway(String arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuilder arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addNewGateway(StringBuffer arg1){
            return (A)addToGateways(new String(arg1));
    }

    public A addToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.add(index, item);
            return (A)this;
    }

    public A setToHosts(int index,String item){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            this.hosts.set(index, item); return (A)this;
    }

    public A addToHosts(String... items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A addAllToHosts(Collection<String> items){
            if (this.hosts == null) {this.hosts = new ArrayList<String>();}
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public A removeAllFromHosts(Collection<String> items){
            for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public String getHost(int index){
            return this.hosts.get(index);
    }

    public String getFirstHost(){
            return this.hosts.get(0);
    }

    public String getLastHost(){
            return this.hosts.get(hosts.size() - 1);
    }

    public String getMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingHost(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: hosts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHosts(List<String> hosts){
            if (this.hosts != null) { _visitables.get("hosts").removeAll(this.hosts);}
            if (hosts != null) {this.hosts = new ArrayList<String>(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
    }

    public A withHosts(String... hosts){
            if (this.hosts != null) {this.hosts.clear();}
            if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public Boolean hasHosts(){
            return hosts != null && !hosts.isEmpty();
    }

    public A addNewHost(String arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuilder arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addNewHost(StringBuffer arg1){
            return (A)addToHosts(new String(arg1));
    }

    public A addToHttp(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item){
            if (this.http == null) {this.http = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);_visitables.get("http").add(index >= 0 ? index : _visitables.get("http").size(), builder);this.http.add(index >= 0 ? index : http.size(), builder); return (A)this;
    }

    public A setToHttp(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item){
            if (this.http == null) {this.http = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);
            if (index < 0 || index >= _visitables.get("http").size()) { _visitables.get("http").add(builder); } else { _visitables.get("http").set(index, builder);}
            if (index < 0 || index >= http.size()) { http.add(builder); } else { http.set(index, builder);}
             return (A)this;
    }

    public A addToHttp(me.snowdrop.istio.api.networking.v1beta1.HTTPRoute... items){
            if (this.http == null) {this.http = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);_visitables.get("http").add(builder);this.http.add(builder);} return (A)this;
    }

    public A addAllToHttp(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPRoute> items){
            if (this.http == null) {this.http = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);_visitables.get("http").add(builder);this.http.add(builder);} return (A)this;
    }

    public A removeFromHttp(me.snowdrop.istio.api.networking.v1beta1.HTTPRoute... items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);_visitables.get("http").remove(builder);if (this.http != null) {this.http.remove(builder);}} return (A)this;
    }

    public A removeAllFromHttp(Collection<me.snowdrop.istio.api.networking.v1beta1.HTTPRoute> items){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(item);_visitables.get("http").remove(builder);if (this.http != null) {this.http.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromHttp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> predicate){
            if (http == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> each = http.iterator();
            final List visitables = _visitables.get("http");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.HTTPRoute> getHttp(){
            return build(http);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.HTTPRoute> buildHttp(){
            return build(http);
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRoute buildHttp(int index){
            return this.http.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRoute buildFirstHttp(){
            return this.http.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRoute buildLastHttp(){
            return this.http.get(http.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.HTTPRoute buildMatchingHttp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder item: http) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingHttp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder item: http) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withHttp(List<me.snowdrop.istio.api.networking.v1beta1.HTTPRoute> http){
            if (this.http != null) { _visitables.get("http").removeAll(this.http);}
            if (http != null) {this.http = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item : http){this.addToHttp(item);}} else { this.http = null;} return (A) this;
    }

    public A withHttp(me.snowdrop.istio.api.networking.v1beta1.HTTPRoute... http){
            if (this.http != null) {this.http.clear();}
            if (http != null) {for (me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item :http){ this.addToHttp(item);}} return (A) this;
    }

    public Boolean hasHttp(){
            return http != null && !http.isEmpty();
    }

    public VirtualServiceSpecFluent.HttpNested<A> addNewHttp(){
            return new HttpNestedImpl();
    }

    public VirtualServiceSpecFluent.HttpNested<A> addNewHttpLike(me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item){
            return new HttpNestedImpl(-1, item);
    }

    public VirtualServiceSpecFluent.HttpNested<A> setNewHttpLike(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item){
            return new HttpNestedImpl(index, item);
    }

    public VirtualServiceSpecFluent.HttpNested<A> editHttp(int index){
            if (http.size() <= index) throw new RuntimeException("Can't edit http. Index exceeds size.");
            return setNewHttpLike(index, buildHttp(index));
    }

    public VirtualServiceSpecFluent.HttpNested<A> editFirstHttp(){
            if (http.size() == 0) throw new RuntimeException("Can't edit first http. The list is empty.");
            return setNewHttpLike(0, buildHttp(0));
    }

    public VirtualServiceSpecFluent.HttpNested<A> editLastHttp(){
            int index = http.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last http. The list is empty.");
            return setNewHttpLike(index, buildHttp(index));
    }

    public VirtualServiceSpecFluent.HttpNested<A> editMatchingHttp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder> predicate){
            int index = -1;
            for (int i=0;i<http.size();i++) { 
            if (predicate.apply(http.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching http. No match found.");
            return setNewHttpLike(index, buildHttp(index));
    }

    public A addToTcp(int index,me.snowdrop.istio.api.networking.v1beta1.TCPRoute item){
            if (this.tcp == null) {this.tcp = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);_visitables.get("tcp").add(index >= 0 ? index : _visitables.get("tcp").size(), builder);this.tcp.add(index >= 0 ? index : tcp.size(), builder); return (A)this;
    }

    public A setToTcp(int index,me.snowdrop.istio.api.networking.v1beta1.TCPRoute item){
            if (this.tcp == null) {this.tcp = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);
            if (index < 0 || index >= _visitables.get("tcp").size()) { _visitables.get("tcp").add(builder); } else { _visitables.get("tcp").set(index, builder);}
            if (index < 0 || index >= tcp.size()) { tcp.add(builder); } else { tcp.set(index, builder);}
             return (A)this;
    }

    public A addToTcp(me.snowdrop.istio.api.networking.v1beta1.TCPRoute... items){
            if (this.tcp == null) {this.tcp = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);_visitables.get("tcp").add(builder);this.tcp.add(builder);} return (A)this;
    }

    public A addAllToTcp(Collection<me.snowdrop.istio.api.networking.v1beta1.TCPRoute> items){
            if (this.tcp == null) {this.tcp = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);_visitables.get("tcp").add(builder);this.tcp.add(builder);} return (A)this;
    }

    public A removeFromTcp(me.snowdrop.istio.api.networking.v1beta1.TCPRoute... items){
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);_visitables.get("tcp").remove(builder);if (this.tcp != null) {this.tcp.remove(builder);}} return (A)this;
    }

    public A removeAllFromTcp(Collection<me.snowdrop.istio.api.networking.v1beta1.TCPRoute> items){
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(item);_visitables.get("tcp").remove(builder);if (this.tcp != null) {this.tcp.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTcp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> predicate){
            if (tcp == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> each = tcp.iterator();
            final List visitables = _visitables.get("tcp");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTcp instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.TCPRoute> getTcp(){
            return build(tcp);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.TCPRoute> buildTcp(){
            return build(tcp);
    }

    public me.snowdrop.istio.api.networking.v1beta1.TCPRoute buildTcp(int index){
            return this.tcp.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TCPRoute buildFirstTcp(){
            return this.tcp.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TCPRoute buildLastTcp(){
            return this.tcp.get(tcp.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TCPRoute buildMatchingTcp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder item: tcp) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTcp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder item: tcp) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTcp(List<me.snowdrop.istio.api.networking.v1beta1.TCPRoute> tcp){
            if (this.tcp != null) { _visitables.get("tcp").removeAll(this.tcp);}
            if (tcp != null) {this.tcp = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item : tcp){this.addToTcp(item);}} else { this.tcp = null;} return (A) this;
    }

    public A withTcp(me.snowdrop.istio.api.networking.v1beta1.TCPRoute... tcp){
            if (this.tcp != null) {this.tcp.clear();}
            if (tcp != null) {for (me.snowdrop.istio.api.networking.v1beta1.TCPRoute item :tcp){ this.addToTcp(item);}} return (A) this;
    }

    public Boolean hasTcp(){
            return tcp != null && !tcp.isEmpty();
    }

    public VirtualServiceSpecFluent.TcpNested<A> addNewTcp(){
            return new TcpNestedImpl();
    }

    public VirtualServiceSpecFluent.TcpNested<A> addNewTcpLike(me.snowdrop.istio.api.networking.v1beta1.TCPRoute item){
            return new TcpNestedImpl(-1, item);
    }

    public VirtualServiceSpecFluent.TcpNested<A> setNewTcpLike(int index,me.snowdrop.istio.api.networking.v1beta1.TCPRoute item){
            return new TcpNestedImpl(index, item);
    }

    public VirtualServiceSpecFluent.TcpNested<A> editTcp(int index){
            if (tcp.size() <= index) throw new RuntimeException("Can't edit tcp. Index exceeds size.");
            return setNewTcpLike(index, buildTcp(index));
    }

    public VirtualServiceSpecFluent.TcpNested<A> editFirstTcp(){
            if (tcp.size() == 0) throw new RuntimeException("Can't edit first tcp. The list is empty.");
            return setNewTcpLike(0, buildTcp(0));
    }

    public VirtualServiceSpecFluent.TcpNested<A> editLastTcp(){
            int index = tcp.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tcp. The list is empty.");
            return setNewTcpLike(index, buildTcp(index));
    }

    public VirtualServiceSpecFluent.TcpNested<A> editMatchingTcp(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder> predicate){
            int index = -1;
            for (int i=0;i<tcp.size();i++) { 
            if (predicate.apply(tcp.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tcp. No match found.");
            return setNewTcpLike(index, buildTcp(index));
    }

    public A addToTls(int index,me.snowdrop.istio.api.networking.v1beta1.TLSRoute item){
            if (this.tls == null) {this.tls = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);_visitables.get("tls").add(index >= 0 ? index : _visitables.get("tls").size(), builder);this.tls.add(index >= 0 ? index : tls.size(), builder); return (A)this;
    }

    public A setToTls(int index,me.snowdrop.istio.api.networking.v1beta1.TLSRoute item){
            if (this.tls == null) {this.tls = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder>();}
            me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);
            if (index < 0 || index >= _visitables.get("tls").size()) { _visitables.get("tls").add(builder); } else { _visitables.get("tls").set(index, builder);}
            if (index < 0 || index >= tls.size()) { tls.add(builder); } else { tls.set(index, builder);}
             return (A)this;
    }

    public A addToTls(me.snowdrop.istio.api.networking.v1beta1.TLSRoute... items){
            if (this.tls == null) {this.tls = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A addAllToTls(Collection<me.snowdrop.istio.api.networking.v1beta1.TLSRoute> items){
            if (this.tls == null) {this.tls = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder>();}
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
    }

    public A removeFromTls(me.snowdrop.istio.api.networking.v1beta1.TLSRoute... items){
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeAllFromTls(Collection<me.snowdrop.istio.api.networking.v1beta1.TLSRoute> items){
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item : items) {me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(item);_visitables.get("tls").remove(builder);if (this.tls != null) {this.tls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTls(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> predicate){
            if (tls == null) return (A) this;
            final Iterator<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> each = tls.iterator();
            final List visitables = _visitables.get("tls");
            while (each.hasNext()) {
              me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public List<me.snowdrop.istio.api.networking.v1beta1.TLSRoute> getTls(){
            return build(tls);
    }

    public List<me.snowdrop.istio.api.networking.v1beta1.TLSRoute> buildTls(){
            return build(tls);
    }

    public me.snowdrop.istio.api.networking.v1beta1.TLSRoute buildTl(int index){
            return this.tls.get(index).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TLSRoute buildFirstTl(){
            return this.tls.get(0).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TLSRoute buildLastTl(){
            return this.tls.get(tls.size() - 1).build();
    }

    public me.snowdrop.istio.api.networking.v1beta1.TLSRoute buildMatchingTl(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder item: tls) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTl(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> predicate){
            for (me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder item: tls) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTls(List<me.snowdrop.istio.api.networking.v1beta1.TLSRoute> tls){
            if (this.tls != null) { _visitables.get("tls").removeAll(this.tls);}
            if (tls != null) {this.tls = new ArrayList<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder>(); for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
    }

    public A withTls(me.snowdrop.istio.api.networking.v1beta1.TLSRoute... tls){
            if (this.tls != null) {this.tls.clear();}
            if (tls != null) {for (me.snowdrop.istio.api.networking.v1beta1.TLSRoute item :tls){ this.addToTls(item);}} return (A) this;
    }

    public Boolean hasTls(){
            return tls != null && !tls.isEmpty();
    }

    public VirtualServiceSpecFluent.TlsNested<A> addNewTl(){
            return new TlsNestedImpl();
    }

    public VirtualServiceSpecFluent.TlsNested<A> addNewTlLike(me.snowdrop.istio.api.networking.v1beta1.TLSRoute item){
            return new TlsNestedImpl(-1, item);
    }

    public VirtualServiceSpecFluent.TlsNested<A> setNewTlLike(int index,me.snowdrop.istio.api.networking.v1beta1.TLSRoute item){
            return new TlsNestedImpl(index, item);
    }

    public VirtualServiceSpecFluent.TlsNested<A> editTl(int index){
            if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
            return setNewTlLike(index, buildTl(index));
    }

    public VirtualServiceSpecFluent.TlsNested<A> editFirstTl(){
            if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
            return setNewTlLike(0, buildTl(0));
    }

    public VirtualServiceSpecFluent.TlsNested<A> editLastTl(){
            int index = tls.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
            return setNewTlLike(index, buildTl(index));
    }

    public VirtualServiceSpecFluent.TlsNested<A> editMatchingTl(io.fabric8.kubernetes.api.builder.Predicate<me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder> predicate){
            int index = -1;
            for (int i=0;i<tls.size();i++) { 
            if (predicate.apply(tls.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
            return setNewTlLike(index, buildTl(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            VirtualServiceSpecFluentImpl that = (VirtualServiceSpecFluentImpl) o;
            if (exportTo != null ? !exportTo.equals(that.exportTo) :that.exportTo != null) return false;
            if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            if (tcp != null ? !tcp.equals(that.tcp) :that.tcp != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.HTTPRouteFluentImpl<VirtualServiceSpecFluent.HttpNested<N>> implements VirtualServiceSpecFluent.HttpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder builder;
        private final int index;
    
            HttpNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.HTTPRoute item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.HTTPRouteBuilder(this);
            }
    
    public N and(){
            return (N) VirtualServiceSpecFluentImpl.this.setToHttp(index,builder.build());
    }
    public N endHttp(){
            return and();
    }

}
    public class TcpNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.TCPRouteFluentImpl<VirtualServiceSpecFluent.TcpNested<N>> implements VirtualServiceSpecFluent.TcpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder builder;
        private final int index;
    
            TcpNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.TCPRoute item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(this, item);
            }
            TcpNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.TCPRouteBuilder(this);
            }
    
    public N and(){
            return (N) VirtualServiceSpecFluentImpl.this.setToTcp(index,builder.build());
    }
    public N endTcp(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.TLSRouteFluentImpl<VirtualServiceSpecFluent.TlsNested<N>> implements VirtualServiceSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder builder;
        private final int index;
    
            TlsNestedImpl(int index,me.snowdrop.istio.api.networking.v1beta1.TLSRoute item){
                    this.index = index;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.index = -1;
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.TLSRouteBuilder(this);
            }
    
    public N and(){
            return (N) VirtualServiceSpecFluentImpl.this.setToTls(index,builder.build());
    }
    public N endTl(){
            return and();
    }

}


}
