package me.snowdrop.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class WorkloadEntryFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.WorkloadEntryFluent<A>> extends BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.WorkloadEntryFluent<A>{

    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder spec;

    public WorkloadEntryFluentImpl(){
    }
    public WorkloadEntryFluentImpl(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntry instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public WorkloadEntryFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public WorkloadEntryFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public WorkloadEntryFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public WorkloadEntryFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public WorkloadEntryFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public WorkloadEntryFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public WorkloadEntryFluent.SpecNested<A> withNewSpecLike(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec item){
            return new SpecNestedImpl(item);
    }

    public WorkloadEntryFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public WorkloadEntryFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder().build());
    }

    public WorkloadEntryFluent.SpecNested<A> editOrNewSpecLike(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            WorkloadEntryFluentImpl that = (WorkloadEntryFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<WorkloadEntryFluent.MetadataNested<N>> implements WorkloadEntryFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) WorkloadEntryFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecFluentImpl<WorkloadEntryFluent.SpecNested<N>> implements WorkloadEntryFluent.SpecNested<N>,Nested<N>{

            private final me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder builder;
    
            SpecNestedImpl(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec item){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecBuilder(this);
            }
    
    public N and(){
            return (N) WorkloadEntryFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}


}
