package me.snowdrop.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public class WorkloadEntrySpecFluentImpl<A extends me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpecFluent<A>{

    private String address;
    private Map<String,String> labels;
    private String locality;
    private String network;
    private Map<String,Integer> ports;
    private String serviceAccount;
    private Integer weight;

    public WorkloadEntrySpecFluentImpl(){
    }
    public WorkloadEntrySpecFluentImpl(me.snowdrop.istio.api.networking.v1beta1.WorkloadEntrySpec instance){
            this.withAddress(instance.getAddress()); 
            this.withLabels(instance.getLabels()); 
            this.withLocality(instance.getLocality()); 
            this.withNetwork(instance.getNetwork()); 
            this.withPorts(instance.getPorts()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withWeight(instance.getWeight()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    public A addToLabels(String key,String value){
            if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map){
            if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
            if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key){
            if(this.labels == null) { return (A) this; }
            if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map){
            if(this.labels == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels(){
            return this.labels;
    }

    public A withLabels(Map<String,String> labels){
            if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels(){
            return this.labels != null;
    }

    public String getLocality(){
            return this.locality;
    }

    public A withLocality(String locality){
            this.locality=locality; return (A) this;
    }

    public Boolean hasLocality(){
            return this.locality != null;
    }

    public A withNewLocality(String arg1){
            return (A)withLocality(new String(arg1));
    }

    public A withNewLocality(StringBuilder arg1){
            return (A)withLocality(new String(arg1));
    }

    public A withNewLocality(StringBuffer arg1){
            return (A)withLocality(new String(arg1));
    }

    public String getNetwork(){
            return this.network;
    }

    public A withNetwork(String network){
            this.network=network; return (A) this;
    }

    public Boolean hasNetwork(){
            return this.network != null;
    }

    public A withNewNetwork(String arg1){
            return (A)withNetwork(new String(arg1));
    }

    public A withNewNetwork(StringBuilder arg1){
            return (A)withNetwork(new String(arg1));
    }

    public A withNewNetwork(StringBuffer arg1){
            return (A)withNetwork(new String(arg1));
    }

    public A addToPorts(String key,Integer value){
            if(this.ports == null && key != null && value != null) { this.ports = new LinkedHashMap<String,Integer>(); }
            if(key != null && value != null) {this.ports.put(key, value);} return (A)this;
    }

    public A addToPorts(Map<String,Integer> map){
            if(this.ports == null && map != null) { this.ports = new LinkedHashMap<String,Integer>(); }
            if(map != null) { this.ports.putAll(map);} return (A)this;
    }

    public A removeFromPorts(String key){
            if(this.ports == null) { return (A) this; }
            if(key != null && this.ports != null) {this.ports.remove(key);} return (A)this;
    }

    public A removeFromPorts(Map<String,Integer> map){
            if(this.ports == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.ports != null){this.ports.remove(key);}}} return (A)this;
    }

    public Map<String,Integer> getPorts(){
            return this.ports;
    }

    public A withPorts(Map<String,Integer> ports){
            if (ports == null) { this.ports =  null;} else {this.ports = new LinkedHashMap<String,Integer>(ports);} return (A) this;
    }

    public Boolean hasPorts(){
            return this.ports != null;
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount != null;
    }

    public A withNewServiceAccount(String arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuilder arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public A withNewServiceAccount(StringBuffer arg1){
            return (A)withServiceAccount(new String(arg1));
    }

    public Integer getWeight(){
            return this.weight;
    }

    public A withWeight(Integer weight){
            this.weight=weight; return (A) this;
    }

    public Boolean hasWeight(){
            return this.weight != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            WorkloadEntrySpecFluentImpl that = (WorkloadEntrySpecFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
            if (locality != null ? !locality.equals(that.locality) :that.locality != null) return false;
            if (network != null ? !network.equals(that.network) :that.network != null) return false;
            if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
            return true;
    }




}
