
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(using = me.snowdrop.istio.api.internal.ClassWithInterfaceFieldsDeserializer.class)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "authType"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Authentication implements Serializable
{

    @JsonProperty("authType")
    @JsonUnwrapped
    private me.snowdrop.istio.api.policy.v1beta1.Authentication.AuthType authType;
    private final static long serialVersionUID = -2726492746753983476L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Authentication() {
    }

    /**
     * 
     * @param authType
     */
    public Authentication(me.snowdrop.istio.api.policy.v1beta1.Authentication.AuthType authType) {
        super();
        this.authType = authType;
    }

    public me.snowdrop.istio.api.policy.v1beta1.Authentication.AuthType getAuthType() {
        return authType;
    }

    public void setAuthType(me.snowdrop.istio.api.policy.v1beta1.Authentication.AuthType authType) {
        this.authType = authType;
    }

    public interface AuthType extends Serializable
    {


    }

}
