package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.Boolean;

public class AuthenticationFluentImpl<A extends AuthenticationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AuthenticationFluent<A>{

    private Authentication.AuthType authType;

    public AuthenticationFluentImpl(){
    }
    public AuthenticationFluentImpl(Authentication instance){
            this.withAuthType(instance.getAuthType()); 
    }

    public Authentication.AuthType getAuthType(){
            return this.authType;
    }

    public A withAuthType(Authentication.AuthType authType){
            this.authType=authType; return (A) this;
    }

    public Boolean hasAuthType(){
            return this.authType != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AuthenticationFluentImpl that = (AuthenticationFluentImpl) o;
            if (authType != null ? !authType.equals(that.authType) :that.authType != null) return false;
            return true;
    }




}
