
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "address",
    "authentication",
    "timeout"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
public class Connection implements Serializable
{

    /**
     * 
     */
    @JsonProperty("address")
    @JsonPropertyDescription("")
    private String address;
    /**
     * 
     */
    @JsonProperty("authentication")
    @JsonPropertyDescription("")
    private Authentication authentication;
    /**
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("")
    private Integer timeout;
    private final static long serialVersionUID = 8871259784050030307L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Connection() {
    }

    /**
     * 
     * @param address
     * @param timeout
     * @param authentication
     */
    public Connection(String address, Authentication authentication, Integer timeout) {
        super();
        this.address = address;
        this.authentication = authentication;
        this.timeout = timeout;
    }

    /**
     * 
     */
    public String getAddress() {
        return address;
    }

    /**
     * 
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 
     */
    public Authentication getAuthentication() {
        return authentication;
    }

    /**
     * 
     */
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    /**
     * 
     */
    public Integer getTimeout() {
        return timeout;
    }

    /**
     * 
     */
    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

}
