package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;

public interface ConnectionFluent<A extends ConnectionFluent<A>> extends Fluent<A>{


    public String getAddress();
    public A withAddress(String address);
    public Boolean hasAddress();
    public A withNewAddress(String arg1);
    public A withNewAddress(StringBuilder arg1);
    public A withNewAddress(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public Authentication getAuthentication();
    public Authentication buildAuthentication();
    public A withAuthentication(Authentication authentication);
    public Boolean hasAuthentication();
    public ConnectionFluent.AuthenticationNested<A> withNewAuthentication();
    public ConnectionFluent.AuthenticationNested<A> withNewAuthenticationLike(Authentication item);
    public ConnectionFluent.AuthenticationNested<A> editAuthentication();
    public ConnectionFluent.AuthenticationNested<A> editOrNewAuthentication();
    public ConnectionFluent.AuthenticationNested<A> editOrNewAuthenticationLike(Authentication item);
    public Integer getTimeout();
    public A withTimeout(Integer timeout);
    public Boolean hasTimeout();

    public interface AuthenticationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthenticationFluent<ConnectionFluent.AuthenticationNested<N>>{

        
    public N and();    public N endAuthentication();
}


}
