package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConnectionFluentImpl<A extends ConnectionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConnectionFluent<A>{

    private String address;
    private AuthenticationBuilder authentication;
    private Integer timeout;

    public ConnectionFluentImpl(){
    }
    public ConnectionFluentImpl(Connection instance){
            this.withAddress(instance.getAddress()); 
            this.withAuthentication(instance.getAuthentication()); 
            this.withTimeout(instance.getTimeout()); 
    }

    public String getAddress(){
            return this.address;
    }

    public A withAddress(String address){
            this.address=address; return (A) this;
    }

    public Boolean hasAddress(){
            return this.address != null;
    }

    public A withNewAddress(String arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1){
            return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1){
            return (A)withAddress(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public Authentication getAuthentication(){
            return this.authentication!=null?this.authentication.build():null;
    }

    public Authentication buildAuthentication(){
            return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(Authentication authentication){
            _visitables.get("authentication").remove(this.authentication);
            if (authentication!=null){ this.authentication= new AuthenticationBuilder(authentication); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public Boolean hasAuthentication(){
            return this.authentication != null;
    }

    public ConnectionFluent.AuthenticationNested<A> withNewAuthentication(){
            return new AuthenticationNestedImpl();
    }

    public ConnectionFluent.AuthenticationNested<A> withNewAuthenticationLike(Authentication item){
            return new AuthenticationNestedImpl(item);
    }

    public ConnectionFluent.AuthenticationNested<A> editAuthentication(){
            return withNewAuthenticationLike(getAuthentication());
    }

    public ConnectionFluent.AuthenticationNested<A> editOrNewAuthentication(){
            return withNewAuthenticationLike(getAuthentication() != null ? getAuthentication(): new AuthenticationBuilder().build());
    }

    public ConnectionFluent.AuthenticationNested<A> editOrNewAuthenticationLike(Authentication item){
            return withNewAuthenticationLike(getAuthentication() != null ? getAuthentication(): item);
    }

    public Integer getTimeout(){
            return this.timeout;
    }

    public A withTimeout(Integer timeout){
            this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout(){
            return this.timeout != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConnectionFluentImpl that = (ConnectionFluentImpl) o;
            if (address != null ? !address.equals(that.address) :that.address != null) return false;
            if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
            if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
            return true;
    }


    public class AuthenticationNestedImpl<N> extends AuthenticationFluentImpl<ConnectionFluent.AuthenticationNested<N>> implements ConnectionFluent.AuthenticationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AuthenticationBuilder builder;
    
            AuthenticationNestedImpl(Authentication item){
                    this.builder = new AuthenticationBuilder(this, item);
            }
            AuthenticationNestedImpl(){
                    this.builder = new AuthenticationBuilder(this);
            }
    
    public N and(){
            return (N) ConnectionFluentImpl.this.withAuthentication(builder.build());
    }
    public N endAuthentication(){
            return and();
    }

}


}
