package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HandlerBuilder extends HandlerFluentImpl<HandlerBuilder> implements VisitableBuilder<Handler,HandlerBuilder>{

    HandlerFluent<?> fluent;
    Boolean validationEnabled;

    public HandlerBuilder(){
            this(true);
    }
    public HandlerBuilder(Boolean validationEnabled){
            this(new Handler(), validationEnabled);
    }
    public HandlerBuilder(HandlerFluent<?> fluent){
            this(fluent, true);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Handler(), validationEnabled);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Handler instance){
            this(fluent, instance, true);
    }
    public HandlerBuilder(HandlerFluent<?> fluent,Handler instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public HandlerBuilder(Handler instance){
            this(instance,true);
    }
    public HandlerBuilder(Handler instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Handler build(){
            Handler buildable = new Handler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HandlerBuilder that = (HandlerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
