package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface HandlerFluent<A extends HandlerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public HandlerFluent.MetadataNested<A> withNewMetadata();
    public HandlerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public HandlerFluent.MetadataNested<A> editMetadata();
    public HandlerFluent.MetadataNested<A> editOrNewMetadata();
    public HandlerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public HandlerSpec getSpec();
    public HandlerSpec buildSpec();
    public A withSpec(HandlerSpec spec);
    public Boolean hasSpec();
    public HandlerFluent.SpecNested<A> withNewSpec();
    public HandlerFluent.SpecNested<A> withNewSpecLike(HandlerSpec item);
    public HandlerFluent.SpecNested<A> editSpec();
    public HandlerFluent.SpecNested<A> editOrNewSpec();
    public HandlerFluent.SpecNested<A> editOrNewSpecLike(HandlerSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<HandlerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,HandlerSpecFluent<HandlerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
