package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HandlerListBuilder extends HandlerListFluentImpl<HandlerListBuilder> implements VisitableBuilder<HandlerList,HandlerListBuilder>{

    HandlerListFluent<?> fluent;
    Boolean validationEnabled;

    public HandlerListBuilder(){
            this(true);
    }
    public HandlerListBuilder(Boolean validationEnabled){
            this(new HandlerList(), validationEnabled);
    }
    public HandlerListBuilder(HandlerListFluent<?> fluent){
            this(fluent, true);
    }
    public HandlerListBuilder(HandlerListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HandlerList(), validationEnabled);
    }
    public HandlerListBuilder(HandlerListFluent<?> fluent,HandlerList instance){
            this(fluent, instance, true);
    }
    public HandlerListBuilder(HandlerListFluent<?> fluent,HandlerList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public HandlerListBuilder(HandlerList instance){
            this(instance,true);
    }
    public HandlerListBuilder(HandlerList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public HandlerList build(){
            HandlerList buildable = new HandlerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HandlerListBuilder that = (HandlerListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
