package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface HandlerListFluent<A extends HandlerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Handler item);
    public A setToItems(int index,Handler item);
    public A addToItems(Handler... items);
    public A addAllToItems(Collection<Handler> items);
    public A removeFromItems(Handler... items);
    public A removeAllFromItems(Collection<Handler> items);
    public A removeMatchingFromItems(Predicate<HandlerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Handler> getItems();
    public List<Handler> buildItems();
    public Handler buildItem(int index);
    public Handler buildFirstItem();
    public Handler buildLastItem();
    public Handler buildMatchingItem(Predicate<HandlerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<HandlerBuilder> predicate);
    public A withItems(List<Handler> items);
    public A withItems(Handler... items);
    public Boolean hasItems();
    public HandlerListFluent.ItemsNested<A> addNewItem();
    public HandlerListFluent.ItemsNested<A> addNewItemLike(Handler item);
    public HandlerListFluent.ItemsNested<A> setNewItemLike(int index,Handler item);
    public HandlerListFluent.ItemsNested<A> editItem(int index);
    public HandlerListFluent.ItemsNested<A> editFirstItem();
    public HandlerListFluent.ItemsNested<A> editLastItem();
    public HandlerListFluent.ItemsNested<A> editMatchingItem(Predicate<HandlerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,HandlerFluent<HandlerListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
