
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "adapter",
    "compiledAdapter",
    "connection",
    "name",
    "params"
})
@IstioKind(name = "handler", plural = "handlers")
@IstioApiVersion("config.istio.io/v1alpha2")
@Version("v1alpha2")
@Group("config.istio.io")
@Plural("handlers")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@JsonDeserialize(using = HandlerSpecDeserializer.class)
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class HandlerSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("adapter")
    @JsonPropertyDescription("")
    private String adapter;
    /**
     * 
     */
    @JsonProperty("connection")
    @JsonPropertyDescription("")
    private Connection connection;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private String name;
    private HandlerParams params;
    private SupportedAdapters compiledAdapter;
    private final static long serialVersionUID = -6246571657732919244L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public HandlerSpec() {
    }

    /**
     * 
     * @param adapter
     * @param compiledAdapter
     * @param name
     * @param connection
     * @param params
     */
    public HandlerSpec(String adapter, SupportedAdapters compiledAdapter, Connection connection, String name, HandlerParams params) {
        super();
        this.adapter = adapter;
        this.compiledAdapter = compiledAdapter;
        this.connection = connection;
        this.name = name;
        this.params = params;
    }

    /**
     * 
     */
    public String getAdapter() {
        return adapter;
    }

    /**
     * 
     */
    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    /**
     * 
     */
    public Connection getConnection() {
        return connection;
    }

    /**
     * 
     */
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /**
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    public HandlerParams getParams() {
        return this.params;
    }

    public void setParams(HandlerParams params) {
        this.params = (params);
    }

    public SupportedAdapters getCompiledAdapter() {
        return this.compiledAdapter;
    }

    public void setCompiledAdapter(SupportedAdapters compiledAdapter) {
        this.compiledAdapter = (compiledAdapter);
    }

}
