package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HandlerSpecBuilder extends HandlerSpecFluentImpl<HandlerSpecBuilder> implements VisitableBuilder<HandlerSpec,HandlerSpecBuilder>{

    HandlerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public HandlerSpecBuilder(){
            this(true);
    }
    public HandlerSpecBuilder(Boolean validationEnabled){
            this(new HandlerSpec(), validationEnabled);
    }
    public HandlerSpecBuilder(HandlerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public HandlerSpecBuilder(HandlerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HandlerSpec(), validationEnabled);
    }
    public HandlerSpecBuilder(HandlerSpecFluent<?> fluent,HandlerSpec instance){
            this(fluent, instance, true);
    }
    public HandlerSpecBuilder(HandlerSpecFluent<?> fluent,HandlerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAdapter(instance.getAdapter()); 
            fluent.withCompiledAdapter(instance.getCompiledAdapter()); 
            fluent.withConnection(instance.getConnection()); 
            fluent.withName(instance.getName()); 
            fluent.withParams(instance.getParams()); 
            this.validationEnabled = validationEnabled; 
    }
    public HandlerSpecBuilder(HandlerSpec instance){
            this(instance,true);
    }
    public HandlerSpecBuilder(HandlerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAdapter(instance.getAdapter()); 
            this.withCompiledAdapter(instance.getCompiledAdapter()); 
            this.withConnection(instance.getConnection()); 
            this.withName(instance.getName()); 
            this.withParams(instance.getParams()); 
            this.validationEnabled = validationEnabled; 
    }

    public HandlerSpec build(){
            HandlerSpec buildable = new HandlerSpec(fluent.getAdapter(),fluent.getCompiledAdapter(),fluent.getConnection(),fluent.getName(),fluent.getParams());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HandlerSpecBuilder that = (HandlerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
