/**
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import me.snowdrop.istio.api.internal.MixerResourceDeserializer;
import me.snowdrop.istio.api.internal.MixerSupportRegistry;

import java.io.IOException;

/**
 * @author <a href="claprun@redhat.com">Christophe Laprun</a>
 */
public class HandlerSpecDeserializer extends JsonDeserializer<HandlerSpec> implements MixerResourceDeserializer<HandlerSpec, HandlerParams> {
	private static final MixerSupportRegistry registry = new MixerSupportRegistry();

	static {
		registry.loadFromProperties("adapters");
	}

	public HandlerSpecDeserializer() {
	}

	@Override
	public HandlerSpec deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
		return (HandlerSpec) deserialize(jsonParser, "compiledAdapter");
	}


	@Override
	public HandlerSpec newInstance() {
		return new HandlerSpec();
	}

	public Class<? extends HandlerParams> getImplementationClass(String compiledTemplate) {
		return registry.getImplementationClass(compiledTemplate).asSubclass(HandlerParams.class);
	}
}
