package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IPAddressBuilder extends IPAddressFluentImpl<IPAddressBuilder> implements VisitableBuilder<IPAddress,IPAddressBuilder>{

    IPAddressFluent<?> fluent;
    Boolean validationEnabled;

    public IPAddressBuilder(){
            this(true);
    }
    public IPAddressBuilder(Boolean validationEnabled){
            this(new IPAddress(), validationEnabled);
    }
    public IPAddressBuilder(IPAddressFluent<?> fluent){
            this(fluent, true);
    }
    public IPAddressBuilder(IPAddressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IPAddress(), validationEnabled);
    }
    public IPAddressBuilder(IPAddressFluent<?> fluent,IPAddress instance){
            this(fluent, instance, true);
    }
    public IPAddressBuilder(IPAddressFluent<?> fluent,IPAddress instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }
    public IPAddressBuilder(IPAddress instance){
            this(instance,true);
    }
    public IPAddressBuilder(IPAddress instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValue(instance.getValue()); 
            this.validationEnabled = validationEnabled; 
    }

    public IPAddress build(){
            IPAddress buildable = new IPAddress(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IPAddressBuilder that = (IPAddressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
