package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstanceBuilder extends InstanceFluentImpl<InstanceBuilder> implements VisitableBuilder<Instance,InstanceBuilder>{

    InstanceFluent<?> fluent;
    Boolean validationEnabled;

    public InstanceBuilder(){
            this(true);
    }
    public InstanceBuilder(Boolean validationEnabled){
            this(new Instance(), validationEnabled);
    }
    public InstanceBuilder(InstanceFluent<?> fluent){
            this(fluent, true);
    }
    public InstanceBuilder(InstanceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Instance(), validationEnabled);
    }
    public InstanceBuilder(InstanceFluent<?> fluent,Instance instance){
            this(fluent, instance, true);
    }
    public InstanceBuilder(InstanceFluent<?> fluent,Instance instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public InstanceBuilder(Instance instance){
            this(instance,true);
    }
    public InstanceBuilder(Instance instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public Instance build(){
            Instance buildable = new Instance(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InstanceBuilder that = (InstanceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
