package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface InstanceFluent<A extends InstanceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public InstanceFluent.MetadataNested<A> withNewMetadata();
    public InstanceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public InstanceFluent.MetadataNested<A> editMetadata();
    public InstanceFluent.MetadataNested<A> editOrNewMetadata();
    public InstanceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public InstanceSpec getSpec();
    public InstanceSpec buildSpec();
    public A withSpec(InstanceSpec spec);
    public Boolean hasSpec();
    public InstanceFluent.SpecNested<A> withNewSpec();
    public InstanceFluent.SpecNested<A> withNewSpecLike(InstanceSpec item);
    public InstanceFluent.SpecNested<A> editSpec();
    public InstanceFluent.SpecNested<A> editOrNewSpec();
    public InstanceFluent.SpecNested<A> editOrNewSpecLike(InstanceSpec item);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<InstanceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,InstanceSpecFluent<InstanceFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}


}
