package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstanceListBuilder extends InstanceListFluentImpl<InstanceListBuilder> implements VisitableBuilder<InstanceList,InstanceListBuilder>{

    InstanceListFluent<?> fluent;
    Boolean validationEnabled;

    public InstanceListBuilder(){
            this(true);
    }
    public InstanceListBuilder(Boolean validationEnabled){
            this(new InstanceList(), validationEnabled);
    }
    public InstanceListBuilder(InstanceListFluent<?> fluent){
            this(fluent, true);
    }
    public InstanceListBuilder(InstanceListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InstanceList(), validationEnabled);
    }
    public InstanceListBuilder(InstanceListFluent<?> fluent,InstanceList instance){
            this(fluent, instance, true);
    }
    public InstanceListBuilder(InstanceListFluent<?> fluent,InstanceList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public InstanceListBuilder(InstanceList instance){
            this(instance,true);
    }
    public InstanceListBuilder(InstanceList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public InstanceList build(){
            InstanceList buildable = new InstanceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InstanceListBuilder that = (InstanceListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
