package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface InstanceListFluent<A extends InstanceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,Instance item);
    public A setToItems(int index,Instance item);
    public A addToItems(Instance... items);
    public A addAllToItems(Collection<Instance> items);
    public A removeFromItems(Instance... items);
    public A removeAllFromItems(Collection<Instance> items);
    public A removeMatchingFromItems(Predicate<InstanceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<Instance> getItems();
    public List<Instance> buildItems();
    public Instance buildItem(int index);
    public Instance buildFirstItem();
    public Instance buildLastItem();
    public Instance buildMatchingItem(Predicate<InstanceBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<InstanceBuilder> predicate);
    public A withItems(List<Instance> items);
    public A withItems(Instance... items);
    public Boolean hasItems();
    public InstanceListFluent.ItemsNested<A> addNewItem();
    public InstanceListFluent.ItemsNested<A> addNewItemLike(Instance item);
    public InstanceListFluent.ItemsNested<A> setNewItemLike(int index,Instance item);
    public InstanceListFluent.ItemsNested<A> editItem(int index);
    public InstanceListFluent.ItemsNested<A> editFirstItem();
    public InstanceListFluent.ItemsNested<A> editLastItem();
    public InstanceListFluent.ItemsNested<A> editMatchingItem(Predicate<InstanceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,InstanceFluent<InstanceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
