
package me.snowdrop.istio.api.policy.v1beta1;

import java.io.Serializable;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "attributeBindings",
    "compiledTemplate",
    "name",
    "params",
    "template"
})
@IstioKind(name = "instance", plural = "instances")
@IstioApiVersion("config.istio.io/v1alpha2")
@Version("v1alpha2")
@Group("config.istio.io")
@Plural("instances")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@JsonDeserialize(using = InstanceSpecDeserializer.class)
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class InstanceSpec implements Serializable, IstioSpec
{

    /**
     * 
     */
    @JsonProperty("attributeBindings")
    @JsonPropertyDescription("")
    private Map<String, String> attributeBindings;
    /**
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("")
    private java.lang.String name;
    /**
     * 
     */
    @JsonProperty("template")
    @JsonPropertyDescription("")
    private java.lang.String template;
    private InstanceParams params;
    private SupportedTemplates compiledTemplate;
    private final static long serialVersionUID = -1481968872394955132L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public InstanceSpec() {
    }

    /**
     * 
     * @param template
     * @param compiledTemplate
     * @param name
     * @param params
     * @param attributeBindings
     */
    public InstanceSpec(Map<String, String> attributeBindings, SupportedTemplates compiledTemplate, java.lang.String name, InstanceParams params, java.lang.String template) {
        super();
        this.attributeBindings = attributeBindings;
        this.compiledTemplate = compiledTemplate;
        this.name = name;
        this.params = params;
        this.template = template;
    }

    /**
     * 
     */
    public Map<String, String> getAttributeBindings() {
        return attributeBindings;
    }

    /**
     * 
     */
    public void setAttributeBindings(Map<String, String> attributeBindings) {
        this.attributeBindings = attributeBindings;
    }

    /**
     * 
     */
    public java.lang.String getName() {
        return name;
    }

    /**
     * 
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }

    /**
     * 
     */
    public java.lang.String getTemplate() {
        return template;
    }

    /**
     * 
     */
    public void setTemplate(java.lang.String template) {
        this.template = template;
    }

    public InstanceParams getParams() {
        return this.params;
    }

    public void setParams(InstanceParams params) {
        this.params = (params);
    }

    public SupportedTemplates getCompiledTemplate() {
        return this.compiledTemplate;
    }

    public void setCompiledTemplate(SupportedTemplates compiledTemplate) {
        this.compiledTemplate = (compiledTemplate);
    }

}
