package me.snowdrop.istio.api.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstanceSpecBuilder extends InstanceSpecFluentImpl<InstanceSpecBuilder> implements VisitableBuilder<InstanceSpec,InstanceSpecBuilder>{

    InstanceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InstanceSpecBuilder(){
            this(true);
    }
    public InstanceSpecBuilder(Boolean validationEnabled){
            this(new InstanceSpec(), validationEnabled);
    }
    public InstanceSpecBuilder(InstanceSpecFluent<?> fluent){
            this(fluent, true);
    }
    public InstanceSpecBuilder(InstanceSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InstanceSpec(), validationEnabled);
    }
    public InstanceSpecBuilder(InstanceSpecFluent<?> fluent,InstanceSpec instance){
            this(fluent, instance, true);
    }
    public InstanceSpecBuilder(InstanceSpecFluent<?> fluent,InstanceSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttributeBindings(instance.getAttributeBindings()); 
            fluent.withCompiledTemplate(instance.getCompiledTemplate()); 
            fluent.withName(instance.getName()); 
            fluent.withParams(instance.getParams()); 
            fluent.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }
    public InstanceSpecBuilder(InstanceSpec instance){
            this(instance,true);
    }
    public InstanceSpecBuilder(InstanceSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttributeBindings(instance.getAttributeBindings()); 
            this.withCompiledTemplate(instance.getCompiledTemplate()); 
            this.withName(instance.getName()); 
            this.withParams(instance.getParams()); 
            this.withTemplate(instance.getTemplate()); 
            this.validationEnabled = validationEnabled; 
    }

    public InstanceSpec build(){
            InstanceSpec buildable = new InstanceSpec(fluent.getAttributeBindings(),fluent.getCompiledTemplate(),fluent.getName(),fluent.getParams(),fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InstanceSpecBuilder that = (InstanceSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
