package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothingFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpan;
import me.snowdrop.istio.mixer.template.apikey.ApiKeyFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothingFluent;
import me.snowdrop.istio.mixer.template.listentry.ListEntryBuilder;
import java.util.Map;
import me.snowdrop.istio.mixer.template.quota.QuotaBuilder;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothing;
import me.snowdrop.istio.mixer.template.apikey.ApiKey;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.mixer.template.edge.EdgeFluent;
import me.snowdrop.istio.mixer.template.edge.EdgeBuilder;
import me.snowdrop.istio.mixer.template.listentry.ListEntryFluent;
import me.snowdrop.istio.mixer.template.authorization.Authorization;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothingBuilder;
import java.lang.Deprecated;
import me.snowdrop.istio.mixer.template.logentry.LogEntryBuilder;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpanBuilder;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothing;
import me.snowdrop.istio.mixer.template.metric.MetricBuilder;
import me.snowdrop.istio.mixer.template.logentry.LogEntry;
import me.snowdrop.istio.mixer.template.listentry.ListEntry;
import me.snowdrop.istio.mixer.template.logentry.LogEntryFluent;
import me.snowdrop.istio.mixer.template.metric.MetricFluent;
import me.snowdrop.istio.mixer.template.authorization.AuthorizationBuilder;
import me.snowdrop.istio.mixer.template.apikey.ApiKeyBuilder;
import me.snowdrop.istio.mixer.template.quota.QuotaFluent;
import java.lang.StringBuffer;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothingBuilder;
import me.snowdrop.istio.mixer.template.quota.Quota;
import me.snowdrop.istio.mixer.template.authorization.AuthorizationFluent;
import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpanFluent;
import me.snowdrop.istio.mixer.template.edge.Edge;

public interface InstanceSpecFluent<A extends InstanceSpecFluent<A>> extends Fluent<A>{


    public A addToAttributeBindings(String key,String value);
    public A addToAttributeBindings(Map<String,String> map);
    public A removeFromAttributeBindings(String key);
    public A removeFromAttributeBindings(Map<String,String> map);
    public Map<String,String> getAttributeBindings();
    public A withAttributeBindings(Map<String,String> attributeBindings);
    public Boolean hasAttributeBindings();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getTemplate();
    public A withTemplate(String template);
    public Boolean hasTemplate();
    public A withNewTemplate(String arg1);
    public A withNewTemplate(StringBuilder arg1);
    public A withNewTemplate(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public InstanceParams getParams();
    public InstanceParams buildParams();
    public A withParams(InstanceParams params);
    public Boolean hasParams();
    public A withEdgeParams(Edge edgeParams);
    public InstanceSpecFluent.EdgeParamsNested<A> withNewEdgeParams();
    public InstanceSpecFluent.EdgeParamsNested<A> withNewEdgeParamsLike(Edge item);
    public A withAuthorizationParams(Authorization authorizationParams);
    public InstanceSpecFluent.AuthorizationParamsNested<A> withNewAuthorizationParams();
    public InstanceSpecFluent.AuthorizationParamsNested<A> withNewAuthorizationParamsLike(Authorization item);
    public A withMetricParams(Metric metricParams);
    public InstanceSpecFluent.MetricParamsNested<A> withNewMetricParams();
    public InstanceSpecFluent.MetricParamsNested<A> withNewMetricParamsLike(Metric item);
    public A withQuotaParams(me.snowdrop.istio.mixer.template.quota.Quota quotaParams);
    public InstanceSpecFluent.QuotaQuotaParamsNested<A> withNewQuotaQuotaParams();
    public InstanceSpecFluent.QuotaQuotaParamsNested<A> withNewQuotaParamsLike(me.snowdrop.istio.mixer.template.quota.Quota item);
    public A withCheckNothingParams(CheckNothing checkNothingParams);
    public InstanceSpecFluent.CheckNothingParamsNested<A> withNewCheckNothingParams();
    public InstanceSpecFluent.CheckNothingParamsNested<A> withNewCheckNothingParamsLike(CheckNothing item);
    public A withNewCheckNothingParams(String name);
    public A withTraceSpanParams(TraceSpan traceSpanParams);
    public InstanceSpecFluent.TraceSpanParamsNested<A> withNewTraceSpanParams();
    public InstanceSpecFluent.TraceSpanParamsNested<A> withNewTraceSpanParamsLike(TraceSpan item);
    public A withReportNothingParams(ReportNothing reportNothingParams);
    public InstanceSpecFluent.ReportNothingParamsNested<A> withNewReportNothingParams();
    public InstanceSpecFluent.ReportNothingParamsNested<A> withNewReportNothingParamsLike(ReportNothing item);
    public A withNewReportNothingParams(String name);
    public A withLogEntryParams(LogEntry logEntryParams);
    public InstanceSpecFluent.LogEntryParamsNested<A> withNewLogEntryParams();
    public InstanceSpecFluent.LogEntryParamsNested<A> withNewLogEntryParamsLike(LogEntry item);
    public A withListEntryParams(ListEntry listEntryParams);
    public InstanceSpecFluent.ListEntryParamsNested<A> withNewListEntryParams();
    public InstanceSpecFluent.ListEntryParamsNested<A> withNewListEntryParamsLike(ListEntry item);
    public A withApiKeyParams(ApiKey apiKeyParams);
    public InstanceSpecFluent.ApiKeyParamsNested<A> withNewApiKeyParams();
    public InstanceSpecFluent.ApiKeyParamsNested<A> withNewApiKeyParamsLike(ApiKey item);
    public SupportedTemplates getCompiledTemplate();
    public A withCompiledTemplate(SupportedTemplates compiledTemplate);
    public Boolean hasCompiledTemplate();

    public interface EdgeParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EdgeFluent<InstanceSpecFluent.EdgeParamsNested<N>>{

        
    public N and();    public N endEdgeParams();
}
    public interface AuthorizationParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AuthorizationFluent<InstanceSpecFluent.AuthorizationParamsNested<N>>{

        
    public N and();    public N endAuthorizationParams();
}
    public interface MetricParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MetricFluent<InstanceSpecFluent.MetricParamsNested<N>>{

        
    public N and();    public N endMetricParams();
}
    public interface QuotaQuotaParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,me.snowdrop.istio.mixer.template.quota.QuotaFluent<InstanceSpecFluent.QuotaQuotaParamsNested<N>>{

        
    public N and();    public N endQuotaQuotaParams();
}
    public interface CheckNothingParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CheckNothingFluent<InstanceSpecFluent.CheckNothingParamsNested<N>>{

        
    public N and();    public N endCheckNothingParams();
}
    public interface TraceSpanParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TraceSpanFluent<InstanceSpecFluent.TraceSpanParamsNested<N>>{

        
    public N and();    public N endTraceSpanParams();
}
    public interface ReportNothingParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReportNothingFluent<InstanceSpecFluent.ReportNothingParamsNested<N>>{

        
    public N and();    public N endReportNothingParams();
}
    public interface LogEntryParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LogEntryFluent<InstanceSpecFluent.LogEntryParamsNested<N>>{

        
    public N and();    public N endLogEntryParams();
}
    public interface ListEntryParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListEntryFluent<InstanceSpecFluent.ListEntryParamsNested<N>>{

        
    public N and();    public N endListEntryParams();
}
    public interface ApiKeyParamsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ApiKeyFluent<InstanceSpecFluent.ApiKeyParamsNested<N>>{

        
    public N and();    public N endApiKeyParams();
}


}
