package me.snowdrop.istio.api.policy.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import me.snowdrop.istio.mixer.template.edge.EdgeFluentImpl;
import java.util.LinkedHashMap;
import me.snowdrop.istio.mixer.template.listentry.ListEntryFluentImpl;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpan;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import me.snowdrop.istio.mixer.template.listentry.ListEntryBuilder;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpanFluentImpl;
import java.lang.Object;
import java.util.Map;
import me.snowdrop.istio.mixer.template.logentry.LogEntryFluentImpl;
import me.snowdrop.istio.mixer.template.apikey.ApiKeyFluentImpl;
import me.snowdrop.istio.mixer.template.quota.QuotaBuilder;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothing;
import me.snowdrop.istio.mixer.template.apikey.ApiKey;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import me.snowdrop.istio.mixer.template.metric.MetricFluentImpl;
import me.snowdrop.istio.mixer.template.edge.EdgeBuilder;
import me.snowdrop.istio.mixer.template.authorization.Authorization;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothingBuilder;
import me.snowdrop.istio.mixer.template.reportnothing.ReportNothingFluentImpl;
import java.lang.Deprecated;
import me.snowdrop.istio.mixer.template.logentry.LogEntryBuilder;
import me.snowdrop.istio.mixer.template.tracespan.TraceSpanBuilder;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothing;
import me.snowdrop.istio.mixer.template.metric.MetricBuilder;
import me.snowdrop.istio.mixer.template.logentry.LogEntry;
import me.snowdrop.istio.mixer.template.listentry.ListEntry;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothingFluentImpl;
import me.snowdrop.istio.mixer.template.authorization.AuthorizationBuilder;
import me.snowdrop.istio.mixer.template.apikey.ApiKeyBuilder;
import me.snowdrop.istio.mixer.template.authorization.AuthorizationFluentImpl;
import java.lang.StringBuffer;
import me.snowdrop.istio.mixer.template.checknothing.CheckNothingBuilder;
import me.snowdrop.istio.mixer.template.quota.Quota;
import me.snowdrop.istio.mixer.template.quota.QuotaFluentImpl;
import me.snowdrop.istio.mixer.template.metric.Metric;
import me.snowdrop.istio.mixer.template.edge.Edge;

public class InstanceSpecFluentImpl<A extends InstanceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements InstanceSpecFluent<A>{

    private Map<String,String> attributeBindings;
    private String name;
    private String template;
    private VisitableBuilder<? extends InstanceParams,?> params;
    private SupportedTemplates compiledTemplate;

    public InstanceSpecFluentImpl(){
    }
    public InstanceSpecFluentImpl(InstanceSpec instance){
            this.withAttributeBindings(instance.getAttributeBindings()); 
            this.withCompiledTemplate(instance.getCompiledTemplate()); 
            this.withName(instance.getName()); 
            this.withParams(instance.getParams()); 
            this.withTemplate(instance.getTemplate()); 
    }

    public A addToAttributeBindings(String key,String value){
            if(this.attributeBindings == null && key != null && value != null) { this.attributeBindings = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.attributeBindings.put(key, value);} return (A)this;
    }

    public A addToAttributeBindings(Map<String,String> map){
            if(this.attributeBindings == null && map != null) { this.attributeBindings = new LinkedHashMap<String,String>(); }
            if(map != null) { this.attributeBindings.putAll(map);} return (A)this;
    }

    public A removeFromAttributeBindings(String key){
            if(this.attributeBindings == null) { return (A) this; }
            if(key != null && this.attributeBindings != null) {this.attributeBindings.remove(key);} return (A)this;
    }

    public A removeFromAttributeBindings(Map<String,String> map){
            if(this.attributeBindings == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.attributeBindings != null){this.attributeBindings.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAttributeBindings(){
            return this.attributeBindings;
    }

    public A withAttributeBindings(Map<String,String> attributeBindings){
            if (attributeBindings == null) { this.attributeBindings =  null;} else {this.attributeBindings = new LinkedHashMap<String,String>(attributeBindings);} return (A) this;
    }

    public Boolean hasAttributeBindings(){
            return this.attributeBindings != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public String getTemplate(){
            return this.template;
    }

    public A withTemplate(String template){
            this.template=template; return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public A withNewTemplate(String arg1){
            return (A)withTemplate(new String(arg1));
    }

    public A withNewTemplate(StringBuilder arg1){
            return (A)withTemplate(new String(arg1));
    }

    public A withNewTemplate(StringBuffer arg1){
            return (A)withTemplate(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildParams instead.
 * @return The buildable object.
 */
@Deprecated public InstanceParams getParams(){
            return this.params!=null?this.params.build():null;
    }

    public InstanceParams buildParams(){
            return this.params!=null?this.params.build():null;
    }

    public A withParams(InstanceParams params){
            if (params instanceof Edge){ this.params= new EdgeBuilder((Edge)params); _visitables.get("params").add(this.params);}
            if (params instanceof Authorization){ this.params= new AuthorizationBuilder((Authorization)params); _visitables.get("params").add(this.params);}
            if (params instanceof Metric){ this.params= new MetricBuilder((Metric)params); _visitables.get("params").add(this.params);}
            if (params instanceof me.snowdrop.istio.mixer.template.quota.Quota){ this.params= new me.snowdrop.istio.mixer.template.quota.QuotaBuilder((me.snowdrop.istio.mixer.template.quota.Quota)params); _visitables.get("params").add(this.params);}
            if (params instanceof CheckNothing){ this.params= new CheckNothingBuilder((CheckNothing)params); _visitables.get("params").add(this.params);}
            if (params instanceof TraceSpan){ this.params= new TraceSpanBuilder((TraceSpan)params); _visitables.get("params").add(this.params);}
            if (params instanceof ReportNothing){ this.params= new ReportNothingBuilder((ReportNothing)params); _visitables.get("params").add(this.params);}
            if (params instanceof LogEntry){ this.params= new LogEntryBuilder((LogEntry)params); _visitables.get("params").add(this.params);}
            if (params instanceof ListEntry){ this.params= new ListEntryBuilder((ListEntry)params); _visitables.get("params").add(this.params);}
            if (params instanceof ApiKey){ this.params= new ApiKeyBuilder((ApiKey)params); _visitables.get("params").add(this.params);}
            return (A) this;
    }

    public Boolean hasParams(){
            return this.params != null;
    }

    public A withEdgeParams(Edge edgeParams){
            _visitables.get("params").remove(this.params);
            if (edgeParams!=null){ this.params= new EdgeBuilder(edgeParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.EdgeParamsNested<A> withNewEdgeParams(){
            return new EdgeParamsNestedImpl();
    }

    public InstanceSpecFluent.EdgeParamsNested<A> withNewEdgeParamsLike(Edge item){
            return new EdgeParamsNestedImpl(item);
    }

    public A withAuthorizationParams(Authorization authorizationParams){
            _visitables.get("params").remove(this.params);
            if (authorizationParams!=null){ this.params= new AuthorizationBuilder(authorizationParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.AuthorizationParamsNested<A> withNewAuthorizationParams(){
            return new AuthorizationParamsNestedImpl();
    }

    public InstanceSpecFluent.AuthorizationParamsNested<A> withNewAuthorizationParamsLike(Authorization item){
            return new AuthorizationParamsNestedImpl(item);
    }

    public A withMetricParams(Metric metricParams){
            _visitables.get("params").remove(this.params);
            if (metricParams!=null){ this.params= new MetricBuilder(metricParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.MetricParamsNested<A> withNewMetricParams(){
            return new MetricParamsNestedImpl();
    }

    public InstanceSpecFluent.MetricParamsNested<A> withNewMetricParamsLike(Metric item){
            return new MetricParamsNestedImpl(item);
    }

    public A withQuotaParams(me.snowdrop.istio.mixer.template.quota.Quota quotaParams){
            _visitables.get("params").remove(this.params);
            if (quotaParams!=null){ this.params= new me.snowdrop.istio.mixer.template.quota.QuotaBuilder(quotaParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.QuotaQuotaParamsNested<A> withNewQuotaQuotaParams(){
            return new QuotaQuotaParamsNestedImpl();
    }

    public InstanceSpecFluent.QuotaQuotaParamsNested<A> withNewQuotaParamsLike(me.snowdrop.istio.mixer.template.quota.Quota item){
            return new QuotaQuotaParamsNestedImpl(item);
    }

    public A withCheckNothingParams(CheckNothing checkNothingParams){
            _visitables.get("params").remove(this.params);
            if (checkNothingParams!=null){ this.params= new CheckNothingBuilder(checkNothingParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.CheckNothingParamsNested<A> withNewCheckNothingParams(){
            return new CheckNothingParamsNestedImpl();
    }

    public InstanceSpecFluent.CheckNothingParamsNested<A> withNewCheckNothingParamsLike(CheckNothing item){
            return new CheckNothingParamsNestedImpl(item);
    }

    public A withNewCheckNothingParams(String name){
            return (A)withCheckNothingParams(new CheckNothing(name));
    }

    public A withTraceSpanParams(TraceSpan traceSpanParams){
            _visitables.get("params").remove(this.params);
            if (traceSpanParams!=null){ this.params= new TraceSpanBuilder(traceSpanParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.TraceSpanParamsNested<A> withNewTraceSpanParams(){
            return new TraceSpanParamsNestedImpl();
    }

    public InstanceSpecFluent.TraceSpanParamsNested<A> withNewTraceSpanParamsLike(TraceSpan item){
            return new TraceSpanParamsNestedImpl(item);
    }

    public A withReportNothingParams(ReportNothing reportNothingParams){
            _visitables.get("params").remove(this.params);
            if (reportNothingParams!=null){ this.params= new ReportNothingBuilder(reportNothingParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.ReportNothingParamsNested<A> withNewReportNothingParams(){
            return new ReportNothingParamsNestedImpl();
    }

    public InstanceSpecFluent.ReportNothingParamsNested<A> withNewReportNothingParamsLike(ReportNothing item){
            return new ReportNothingParamsNestedImpl(item);
    }

    public A withNewReportNothingParams(String name){
            return (A)withReportNothingParams(new ReportNothing(name));
    }

    public A withLogEntryParams(LogEntry logEntryParams){
            _visitables.get("params").remove(this.params);
            if (logEntryParams!=null){ this.params= new LogEntryBuilder(logEntryParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.LogEntryParamsNested<A> withNewLogEntryParams(){
            return new LogEntryParamsNestedImpl();
    }

    public InstanceSpecFluent.LogEntryParamsNested<A> withNewLogEntryParamsLike(LogEntry item){
            return new LogEntryParamsNestedImpl(item);
    }

    public A withListEntryParams(ListEntry listEntryParams){
            _visitables.get("params").remove(this.params);
            if (listEntryParams!=null){ this.params= new ListEntryBuilder(listEntryParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.ListEntryParamsNested<A> withNewListEntryParams(){
            return new ListEntryParamsNestedImpl();
    }

    public InstanceSpecFluent.ListEntryParamsNested<A> withNewListEntryParamsLike(ListEntry item){
            return new ListEntryParamsNestedImpl(item);
    }

    public A withApiKeyParams(ApiKey apiKeyParams){
            _visitables.get("params").remove(this.params);
            if (apiKeyParams!=null){ this.params= new ApiKeyBuilder(apiKeyParams); _visitables.get("params").add(this.params);} return (A) this;
    }

    public InstanceSpecFluent.ApiKeyParamsNested<A> withNewApiKeyParams(){
            return new ApiKeyParamsNestedImpl();
    }

    public InstanceSpecFluent.ApiKeyParamsNested<A> withNewApiKeyParamsLike(ApiKey item){
            return new ApiKeyParamsNestedImpl(item);
    }

    public SupportedTemplates getCompiledTemplate(){
            return this.compiledTemplate;
    }

    public A withCompiledTemplate(SupportedTemplates compiledTemplate){
            this.compiledTemplate=compiledTemplate; return (A) this;
    }

    public Boolean hasCompiledTemplate(){
            return this.compiledTemplate != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            InstanceSpecFluentImpl that = (InstanceSpecFluentImpl) o;
            if (attributeBindings != null ? !attributeBindings.equals(that.attributeBindings) :that.attributeBindings != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (params != null ? !params.equals(that.params) :that.params != null) return false;
            if (compiledTemplate != null ? !compiledTemplate.equals(that.compiledTemplate) :that.compiledTemplate != null) return false;
            return true;
    }


    public class EdgeParamsNestedImpl<N> extends EdgeFluentImpl<InstanceSpecFluent.EdgeParamsNested<N>> implements InstanceSpecFluent.EdgeParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EdgeBuilder builder;
    
            EdgeParamsNestedImpl(Edge item){
                    this.builder = new EdgeBuilder(this, item);
            }
            EdgeParamsNestedImpl(){
                    this.builder = new EdgeBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endEdgeParams(){
            return and();
    }

}
    public class AuthorizationParamsNestedImpl<N> extends AuthorizationFluentImpl<InstanceSpecFluent.AuthorizationParamsNested<N>> implements InstanceSpecFluent.AuthorizationParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AuthorizationBuilder builder;
    
            AuthorizationParamsNestedImpl(Authorization item){
                    this.builder = new AuthorizationBuilder(this, item);
            }
            AuthorizationParamsNestedImpl(){
                    this.builder = new AuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endAuthorizationParams(){
            return and();
    }

}
    public class MetricParamsNestedImpl<N> extends MetricFluentImpl<InstanceSpecFluent.MetricParamsNested<N>> implements InstanceSpecFluent.MetricParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final MetricBuilder builder;
    
            MetricParamsNestedImpl(Metric item){
                    this.builder = new MetricBuilder(this, item);
            }
            MetricParamsNestedImpl(){
                    this.builder = new MetricBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endMetricParams(){
            return and();
    }

}
    public class QuotaQuotaParamsNestedImpl<N> extends me.snowdrop.istio.mixer.template.quota.QuotaFluentImpl<InstanceSpecFluent.QuotaQuotaParamsNested<N>> implements InstanceSpecFluent.QuotaQuotaParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.mixer.template.quota.QuotaBuilder builder;
    
            QuotaQuotaParamsNestedImpl(me.snowdrop.istio.mixer.template.quota.Quota item){
                    this.builder = new me.snowdrop.istio.mixer.template.quota.QuotaBuilder(this, item);
            }
            QuotaQuotaParamsNestedImpl(){
                    this.builder = new me.snowdrop.istio.mixer.template.quota.QuotaBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endQuotaQuotaParams(){
            return and();
    }

}
    public class CheckNothingParamsNestedImpl<N> extends CheckNothingFluentImpl<InstanceSpecFluent.CheckNothingParamsNested<N>> implements InstanceSpecFluent.CheckNothingParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CheckNothingBuilder builder;
    
            CheckNothingParamsNestedImpl(CheckNothing item){
                    this.builder = new CheckNothingBuilder(this, item);
            }
            CheckNothingParamsNestedImpl(){
                    this.builder = new CheckNothingBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endCheckNothingParams(){
            return and();
    }

}
    public class TraceSpanParamsNestedImpl<N> extends TraceSpanFluentImpl<InstanceSpecFluent.TraceSpanParamsNested<N>> implements InstanceSpecFluent.TraceSpanParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TraceSpanBuilder builder;
    
            TraceSpanParamsNestedImpl(TraceSpan item){
                    this.builder = new TraceSpanBuilder(this, item);
            }
            TraceSpanParamsNestedImpl(){
                    this.builder = new TraceSpanBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endTraceSpanParams(){
            return and();
    }

}
    public class ReportNothingParamsNestedImpl<N> extends ReportNothingFluentImpl<InstanceSpecFluent.ReportNothingParamsNested<N>> implements InstanceSpecFluent.ReportNothingParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReportNothingBuilder builder;
    
            ReportNothingParamsNestedImpl(ReportNothing item){
                    this.builder = new ReportNothingBuilder(this, item);
            }
            ReportNothingParamsNestedImpl(){
                    this.builder = new ReportNothingBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endReportNothingParams(){
            return and();
    }

}
    public class LogEntryParamsNestedImpl<N> extends LogEntryFluentImpl<InstanceSpecFluent.LogEntryParamsNested<N>> implements InstanceSpecFluent.LogEntryParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LogEntryBuilder builder;
    
            LogEntryParamsNestedImpl(LogEntry item){
                    this.builder = new LogEntryBuilder(this, item);
            }
            LogEntryParamsNestedImpl(){
                    this.builder = new LogEntryBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endLogEntryParams(){
            return and();
    }

}
    public class ListEntryParamsNestedImpl<N> extends ListEntryFluentImpl<InstanceSpecFluent.ListEntryParamsNested<N>> implements InstanceSpecFluent.ListEntryParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListEntryBuilder builder;
    
            ListEntryParamsNestedImpl(ListEntry item){
                    this.builder = new ListEntryBuilder(this, item);
            }
            ListEntryParamsNestedImpl(){
                    this.builder = new ListEntryBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endListEntryParams(){
            return and();
    }

}
    public class ApiKeyParamsNestedImpl<N> extends ApiKeyFluentImpl<InstanceSpecFluent.ApiKeyParamsNested<N>> implements InstanceSpecFluent.ApiKeyParamsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ApiKeyBuilder builder;
    
            ApiKeyParamsNestedImpl(ApiKey item){
                    this.builder = new ApiKeyBuilder(this, item);
            }
            ApiKeyParamsNestedImpl(){
                    this.builder = new ApiKeyBuilder(this);
            }
    
    public N and(){
            return (N) InstanceSpecFluentImpl.this.withParams(builder.build());
    }
    public N endApiKeyParams(){
            return and();
    }

}


}
