
package me.snowdrop.istio.api.policy.v1beta1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * 
 */
public enum SupportedAdapters {

    BYPASS("bypass"),
    CIRCONUS("circonus"),
    CLOUDWATCH("cloudwatch"),
    DENIER("denier"),
    DOGSTATSD("dogstatsd"),
    FLUENTD("fluentd"),
    KUBERNETESENV("kubernetesenv"),
    LISTCHECKER("listchecker"),
    MEMQUOTA("memquota"),
    NOOP("noop"),
    OPA("opa"),
    PROMETHEUS("prometheus"),
    REDISQUOTA("redisquota"),
    SOLARWINDS("solarwinds"),
    STACKDRIVER("stackdriver"),
    STATSD("statsd"),
    STDIO("stdio"),
    ZIPKIN("zipkin");
    private final String value;
    private final static Map<String, SupportedAdapters> CONSTANTS = new HashMap<String, SupportedAdapters>();

    static {
        for (SupportedAdapters c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private SupportedAdapters(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SupportedAdapters fromValue(String value) {
        SupportedAdapters constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
