
package me.snowdrop.istio.api.policy.v1beta1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;


/**
 * 
 */
public enum SupportedTemplates {

    APIKEY("apikey"),
    AUTHORIZATION("authorization"),
    CHECKNOTHING("checknothing"),
    EDGE("edge"),
    KUBERNETES("kubernetes"),
    LISTENTRY("listentry"),
    LOGENTRY("logentry"),
    METRIC("metric"),
    QUOTA("quota"),
    REPORTNOTHING("reportnothing"),
    TRACESPAN("tracespan");
    private final String value;
    private final static Map<String, SupportedTemplates> CONSTANTS = new HashMap<String, SupportedTemplates>();

    static {
        for (SupportedTemplates c: values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private SupportedTemplates(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SupportedTemplates fromValue(String value) {
        SupportedTemplates constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        } else {
            return constant;
        }
    }

}
