package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthorizationPolicyBuilder extends AuthorizationPolicyFluentImpl<AuthorizationPolicyBuilder> implements VisitableBuilder<AuthorizationPolicy,AuthorizationPolicyBuilder>{

    AuthorizationPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public AuthorizationPolicyBuilder(){
            this(true);
    }
    public AuthorizationPolicyBuilder(Boolean validationEnabled){
            this(new AuthorizationPolicy(), validationEnabled);
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthorizationPolicy(), validationEnabled);
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,AuthorizationPolicy instance){
            this(fluent, instance, true);
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicyFluent<?> fluent,AuthorizationPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicy instance){
            this(instance,true);
    }
    public AuthorizationPolicyBuilder(AuthorizationPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.validationEnabled = validationEnabled; 
    }

    public AuthorizationPolicy build(){
            AuthorizationPolicy buildable = new AuthorizationPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationPolicyBuilder that = (AuthorizationPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
