
package me.snowdrop.istio.api.security.v1beta1;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Version;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import me.snowdrop.istio.api.IstioSpec;
import me.snowdrop.istio.api.internal.IstioApiVersion;
import me.snowdrop.istio.api.internal.IstioKind;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;


/**
 * 
 */
@JsonInclude(JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "action",
    "rules",
    "selector"
})
@IstioKind(name = "AuthorizationPolicy", plural = "authorizationpolicies")
@IstioApiVersion("security.istio.io/v1beta1")
@Version("v1beta1")
@Group("security.istio.io")
@Plural("authorizationpolicies")
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class)
})
@VelocityTransformations({
    @VelocityTransformation("/istio-resource.vm"),
    @VelocityTransformation("/istio-resource-list.vm"),
    @VelocityTransformation(value = "/istio-manifest.vm", outputPath = "crd.properties", gather = true),
    @VelocityTransformation(value = "/istio-mappings-provider.vm", outputPath = "me/snowdrop/istio/api/model/IstioResourceMappingsProvider.java", gather = true)
})
public class AuthorizationPolicySpec implements Serializable, IstioSpec
{

    @JsonProperty("action")
    private Action action;
    /**
     * 
     */
    @JsonProperty("rules")
    @JsonPropertyDescription("")
    private List<Rule> rules = new ArrayList<Rule>();
    /**
     * 
     */
    @JsonProperty("selector")
    @JsonPropertyDescription("")
    private WorkloadSelector selector;
    private final static long serialVersionUID = 7060730756144324497L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AuthorizationPolicySpec() {
    }

    /**
     * 
     * @param action
     * @param rules
     * @param selector
     */
    public AuthorizationPolicySpec(Action action, List<Rule> rules, WorkloadSelector selector) {
        super();
        this.action = action;
        this.rules = rules;
        this.selector = selector;
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    /**
     * 
     */
    public List<Rule> getRules() {
        return rules;
    }

    /**
     * 
     */
    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    /**
     * 
     */
    public WorkloadSelector getSelector() {
        return selector;
    }

    /**
     * 
     */
    public void setSelector(WorkloadSelector selector) {
        this.selector = selector;
    }

}
