package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AuthorizationPolicySpecBuilder extends AuthorizationPolicySpecFluentImpl<AuthorizationPolicySpecBuilder> implements VisitableBuilder<AuthorizationPolicySpec,AuthorizationPolicySpecBuilder>{

    AuthorizationPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public AuthorizationPolicySpecBuilder(){
            this(true);
    }
    public AuthorizationPolicySpecBuilder(Boolean validationEnabled){
            this(new AuthorizationPolicySpec(), validationEnabled);
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AuthorizationPolicySpec(), validationEnabled);
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpecFluent<?> fluent,AuthorizationPolicySpec instance){
            this(fluent, instance, true);
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpecFluent<?> fluent,AuthorizationPolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAction(instance.getAction()); 
            fluent.withRules(instance.getRules()); 
            fluent.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpec instance){
            this(instance,true);
    }
    public AuthorizationPolicySpecBuilder(AuthorizationPolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAction(instance.getAction()); 
            this.withRules(instance.getRules()); 
            this.withSelector(instance.getSelector()); 
            this.validationEnabled = validationEnabled; 
    }

    public AuthorizationPolicySpec build(){
            AuthorizationPolicySpec buildable = new AuthorizationPolicySpec(fluent.getAction(),fluent.getRules(),fluent.getSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AuthorizationPolicySpecBuilder that = (AuthorizationPolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
