package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

public class AuthorizationPolicySpecFluentImpl<A extends AuthorizationPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AuthorizationPolicySpecFluent<A>{

    private me.snowdrop.istio.api.security.v1beta1.Action action;
    private List<RuleBuilder> rules;
    private me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder selector;

    public AuthorizationPolicySpecFluentImpl(){
    }
    public AuthorizationPolicySpecFluentImpl(AuthorizationPolicySpec instance){
            this.withAction(instance.getAction()); 
            this.withRules(instance.getRules()); 
            this.withSelector(instance.getSelector()); 
    }

    public me.snowdrop.istio.api.security.v1beta1.Action getAction(){
            return this.action;
    }

    public A withAction(me.snowdrop.istio.api.security.v1beta1.Action action){
            this.action=action; return (A) this;
    }

    public Boolean hasAction(){
            return this.action != null;
    }

    public A addToRules(int index,Rule item){
            if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
            RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,Rule item){
            if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
            RuleBuilder builder = new RuleBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(Rule... items){
            if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
            for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<Rule> items){
            if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
            for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(Rule... items){
            for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<Rule> items){
            for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromRules(io.fabric8.kubernetes.api.builder.Predicate<RuleBuilder> predicate){
            if (rules == null) return (A) this;
            final Iterator<RuleBuilder> each = rules.iterator();
            final List visitables = _visitables.get("rules");
            while (each.hasNext()) {
              RuleBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<Rule> getRules(){
            return build(rules);
    }

    public List<Rule> buildRules(){
            return build(rules);
    }

    public Rule buildRule(int index){
            return this.rules.get(index).build();
    }

    public Rule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public Rule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public Rule buildMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleBuilder> predicate){
            for (RuleBuilder item: rules) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleBuilder> predicate){
            for (RuleBuilder item: rules) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withRules(List<Rule> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<RuleBuilder>(); for (Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(Rule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (Rule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> addNewRuleLike(Rule item){
            return new RulesNestedImpl(-1, item);
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> setNewRuleLike(int index,Rule item){
            return new RulesNestedImpl(index, item);
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public AuthorizationPolicySpecFluent.RulesNested<A> editMatchingRule(io.fabric8.kubernetes.api.builder.Predicate<RuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public me.snowdrop.istio.api.type.v1beta1.WorkloadSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public AuthorizationPolicySpecFluent.V1beta1SelectorNested<A> withNewV1beta1Selector(){
            return new V1beta1SelectorNestedImpl();
    }

    public AuthorizationPolicySpecFluent.V1beta1SelectorNested<A> withNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return new V1beta1SelectorNestedImpl(item);
    }

    public AuthorizationPolicySpecFluent.V1beta1SelectorNested<A> editV1beta1Selector(){
            return withNewSelectorLike(getSelector());
    }

    public AuthorizationPolicySpecFluent.V1beta1SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder().build());
    }

    public AuthorizationPolicySpecFluent.V1beta1SelectorNested<A> editOrNewSelectorLike(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            AuthorizationPolicySpecFluentImpl that = (AuthorizationPolicySpecFluentImpl) o;
            if (action != null ? !action.equals(that.action) :that.action != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }


    public class RulesNestedImpl<N> extends RuleFluentImpl<AuthorizationPolicySpecFluent.RulesNested<N>> implements AuthorizationPolicySpecFluent.RulesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,Rule item){
                    this.index = index;
                    this.builder = new RuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new RuleBuilder(this);
            }
    
    public N and(){
            return (N) AuthorizationPolicySpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule(){
            return and();
    }

}
    public class V1beta1SelectorNestedImpl<N> extends me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorFluentImpl<AuthorizationPolicySpecFluent.V1beta1SelectorNested<N>> implements AuthorizationPolicySpecFluent.V1beta1SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder builder;
    
            V1beta1SelectorNestedImpl(me.snowdrop.istio.api.type.v1beta1.WorkloadSelector item){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this, item);
            }
            V1beta1SelectorNestedImpl(){
                    this.builder = new me.snowdrop.istio.api.type.v1beta1.WorkloadSelectorBuilder(this);
            }
    
    public N and(){
            return (N) AuthorizationPolicySpecFluentImpl.this.withSelector(builder.build());
    }
    public N endV1beta1Selector(){
            return and();
    }

}


}
