package me.snowdrop.istio.api.security.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ConditionFluentImpl<A extends ConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConditionFluent<A>{

    private String key;
    private List<String> notValues;
    private List<String> values;

    public ConditionFluentImpl(){
    }
    public ConditionFluentImpl(me.snowdrop.istio.api.security.v1beta1.Condition instance){
            this.withKey(instance.getKey()); 
            this.withNotValues(instance.getNotValues()); 
            this.withValues(instance.getValues()); 
    }

    public String getKey(){
            return this.key;
    }

    public A withKey(String key){
            this.key=key; return (A) this;
    }

    public Boolean hasKey(){
            return this.key != null;
    }

    public A withNewKey(String arg1){
            return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuilder arg1){
            return (A)withKey(new String(arg1));
    }

    public A withNewKey(StringBuffer arg1){
            return (A)withKey(new String(arg1));
    }

    public A addToNotValues(int index,String item){
            if (this.notValues == null) {this.notValues = new ArrayList<String>();}
            this.notValues.add(index, item);
            return (A)this;
    }

    public A setToNotValues(int index,String item){
            if (this.notValues == null) {this.notValues = new ArrayList<String>();}
            this.notValues.set(index, item); return (A)this;
    }

    public A addToNotValues(String... items){
            if (this.notValues == null) {this.notValues = new ArrayList<String>();}
            for (String item : items) {this.notValues.add(item);} return (A)this;
    }

    public A addAllToNotValues(Collection<String> items){
            if (this.notValues == null) {this.notValues = new ArrayList<String>();}
            for (String item : items) {this.notValues.add(item);} return (A)this;
    }

    public A removeFromNotValues(String... items){
            for (String item : items) {if (this.notValues!= null){ this.notValues.remove(item);}} return (A)this;
    }

    public A removeAllFromNotValues(Collection<String> items){
            for (String item : items) {if (this.notValues!= null){ this.notValues.remove(item);}} return (A)this;
    }

    public List<String> getNotValues(){
            return this.notValues;
    }

    public String getNotValue(int index){
            return this.notValues.get(index);
    }

    public String getFirstNotValue(){
            return this.notValues.get(0);
    }

    public String getLastNotValue(){
            return this.notValues.get(notValues.size() - 1);
    }

    public String getMatchingNotValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notValues) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNotValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: notValues) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNotValues(List<String> notValues){
            if (this.notValues != null) { _visitables.get("notValues").removeAll(this.notValues);}
            if (notValues != null) {this.notValues = new ArrayList<String>(); for (String item : notValues){this.addToNotValues(item);}} else { this.notValues = null;} return (A) this;
    }

    public A withNotValues(String... notValues){
            if (this.notValues != null) {this.notValues.clear();}
            if (notValues != null) {for (String item :notValues){ this.addToNotValues(item);}} return (A) this;
    }

    public Boolean hasNotValues(){
            return notValues != null && !notValues.isEmpty();
    }

    public A addNewNotValue(String arg1){
            return (A)addToNotValues(new String(arg1));
    }

    public A addNewNotValue(StringBuilder arg1){
            return (A)addToNotValues(new String(arg1));
    }

    public A addNewNotValue(StringBuffer arg1){
            return (A)addToNotValues(new String(arg1));
    }

    public A addToValues(int index,String item){
            if (this.values == null) {this.values = new ArrayList<String>();}
            this.values.add(index, item);
            return (A)this;
    }

    public A setToValues(int index,String item){
            if (this.values == null) {this.values = new ArrayList<String>();}
            this.values.set(index, item); return (A)this;
    }

    public A addToValues(String... items){
            if (this.values == null) {this.values = new ArrayList<String>();}
            for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A addAllToValues(Collection<String> items){
            if (this.values == null) {this.values = new ArrayList<String>();}
            for (String item : items) {this.values.add(item);} return (A)this;
    }

    public A removeFromValues(String... items){
            for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public A removeAllFromValues(Collection<String> items){
            for (String item : items) {if (this.values!= null){ this.values.remove(item);}} return (A)this;
    }

    public List<String> getValues(){
            return this.values;
    }

    public String getValue(int index){
            return this.values.get(index);
    }

    public String getFirstValue(){
            return this.values.get(0);
    }

    public String getLastValue(){
            return this.values.get(values.size() - 1);
    }

    public String getMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: values) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingValue(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: values) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withValues(List<String> values){
            if (this.values != null) { _visitables.get("values").removeAll(this.values);}
            if (values != null) {this.values = new ArrayList<String>(); for (String item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
    }

    public A withValues(String... values){
            if (this.values != null) {this.values.clear();}
            if (values != null) {for (String item :values){ this.addToValues(item);}} return (A) this;
    }

    public Boolean hasValues(){
            return values != null && !values.isEmpty();
    }

    public A addNewValue(String arg1){
            return (A)addToValues(new String(arg1));
    }

    public A addNewValue(StringBuilder arg1){
            return (A)addToValues(new String(arg1));
    }

    public A addNewValue(StringBuffer arg1){
            return (A)addToValues(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ConditionFluentImpl that = (ConditionFluentImpl) o;
            if (key != null ? !key.equals(that.key) :that.key != null) return false;
            if (notValues != null ? !notValues.equals(that.notValues) :that.notValues != null) return false;
            if (values != null ? !values.equals(that.values) :that.values != null) return false;
            return true;
    }




}
