package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FromBuilder extends FromFluentImpl<FromBuilder> implements VisitableBuilder<From,FromBuilder>{

    FromFluent<?> fluent;
    Boolean validationEnabled;

    public FromBuilder(){
            this(true);
    }
    public FromBuilder(Boolean validationEnabled){
            this(new From(), validationEnabled);
    }
    public FromBuilder(FromFluent<?> fluent){
            this(fluent, true);
    }
    public FromBuilder(FromFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new From(), validationEnabled);
    }
    public FromBuilder(FromFluent<?> fluent,From instance){
            this(fluent, instance, true);
    }
    public FromBuilder(FromFluent<?> fluent,From instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }
    public FromBuilder(From instance){
            this(instance,true);
    }
    public FromBuilder(From instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSource(instance.getSource()); 
            this.validationEnabled = validationEnabled; 
    }

    public From build(){
            From buildable = new From(fluent.getSource());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FromBuilder that = (FromBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
