package me.snowdrop.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JWTHeaderBuilder extends JWTHeaderFluentImpl<JWTHeaderBuilder> implements VisitableBuilder<JWTHeader,JWTHeaderBuilder>{

    JWTHeaderFluent<?> fluent;
    Boolean validationEnabled;

    public JWTHeaderBuilder(){
            this(true);
    }
    public JWTHeaderBuilder(Boolean validationEnabled){
            this(new JWTHeader(), validationEnabled);
    }
    public JWTHeaderBuilder(JWTHeaderFluent<?> fluent){
            this(fluent, true);
    }
    public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JWTHeader(), validationEnabled);
    }
    public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,JWTHeader instance){
            this(fluent, instance, true);
    }
    public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,JWTHeader instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName()); 
            fluent.withPrefix(instance.getPrefix()); 
            this.validationEnabled = validationEnabled; 
    }
    public JWTHeaderBuilder(JWTHeader instance){
            this(instance,true);
    }
    public JWTHeaderBuilder(JWTHeader instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName()); 
            this.withPrefix(instance.getPrefix()); 
            this.validationEnabled = validationEnabled; 
    }

    public JWTHeader build(){
            JWTHeader buildable = new JWTHeader(fluent.getName(),fluent.getPrefix());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JWTHeaderBuilder that = (JWTHeaderBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
